/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.DiskCachePolicy;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.concurrent.atomic.AtomicBoolean;

public class SmallCacheIfRequestedDiskCachePolicy
implements DiskCachePolicy {
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;

    public SmallCacheIfRequestedDiskCachePolicy(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
    }

    @Override
    public Task<EncodedImage> createAndStartCacheReadTask(ImageRequest imageRequest, Object callerContext, AtomicBoolean isCancelled) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, callerContext);
        if (imageRequest.getCacheChoice() == ImageRequest.CacheChoice.SMALL) {
            return this.mSmallImageBufferedDiskCache.get(cacheKey, isCancelled);
        }
        return this.mDefaultBufferedDiskCache.get(cacheKey, isCancelled);
    }

    @Override
    public void writeToCache(EncodedImage newResult, ImageRequest imageRequest, Object callerContext) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, callerContext);
        if (imageRequest.getCacheChoice() == ImageRequest.CacheChoice.SMALL) {
            this.mSmallImageBufferedDiskCache.put(cacheKey, newResult);
        } else {
            this.mDefaultBufferedDiskCache.put(cacheKey, newResult);
        }
    }
}

