/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.os.SystemClock;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.FetchState;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;

public class NetworkFetchProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "NetworkFetchProducer";
    public static final String INTERMEDIATE_RESULT_PRODUCER_EVENT = "intermediate_result";
    private static final int READ_SIZE = 16384;
    @VisibleForTesting
    static final long TIME_BETWEEN_PARTIAL_RESULTS_MS = 100L;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final ByteArrayPool mByteArrayPool;
    private final NetworkFetcher mNetworkFetcher;

    public NetworkFetchProducer(PooledByteBufferFactory pooledByteBufferFactory, ByteArrayPool byteArrayPool, NetworkFetcher networkFetcher) {
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mByteArrayPool = byteArrayPool;
        this.mNetworkFetcher = networkFetcher;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        context.getListener().onProducerStart(context.getId(), PRODUCER_NAME);
        Object fetchState = this.mNetworkFetcher.createFetchState(consumer, context);
        this.mNetworkFetcher.fetch(fetchState, new NetworkFetcher.Callback((FetchState)fetchState){
            final /* synthetic */ FetchState val$fetchState;
            {
                this.val$fetchState = fetchState;
            }

            @Override
            public void onResponse(InputStream response, int responseLength) throws IOException {
                NetworkFetchProducer.this.onResponse(this.val$fetchState, response, responseLength);
            }

            @Override
            public void onFailure(Throwable throwable) {
                NetworkFetchProducer.this.onFailure(this.val$fetchState, throwable);
            }

            @Override
            public void onCancellation() {
                NetworkFetchProducer.this.onCancellation(this.val$fetchState);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(FetchState fetchState, InputStream responseData, int responseContentLength) throws IOException {
        PooledByteBufferOutputStream pooledOutputStream = responseContentLength > 0 ? this.mPooledByteBufferFactory.newOutputStream(responseContentLength) : this.mPooledByteBufferFactory.newOutputStream();
        byte[] ioArray = (byte[])this.mByteArrayPool.get(16384);
        try {
            int length;
            while ((length = responseData.read(ioArray)) >= 0) {
                if (length <= 0) continue;
                pooledOutputStream.write(ioArray, 0, length);
                this.maybeHandleIntermediateResult(pooledOutputStream, fetchState);
                float progress = NetworkFetchProducer.calculateProgress(pooledOutputStream.size(), responseContentLength);
                fetchState.getConsumer().onProgressUpdate(progress);
            }
            this.mNetworkFetcher.onFetchCompletion(fetchState, pooledOutputStream.size());
            this.handleFinalResult(pooledOutputStream, fetchState);
        }
        finally {
            this.mByteArrayPool.release((Object)ioArray);
            pooledOutputStream.close();
        }
    }

    private static float calculateProgress(int downloaded, int total) {
        if (total > 0) {
            return (float)downloaded / (float)total;
        }
        return 1.0f - (float)Math.exp((double)(-downloaded) / 50000.0);
    }

    private void maybeHandleIntermediateResult(PooledByteBufferOutputStream pooledOutputStream, FetchState fetchState) {
        long nowMs = SystemClock.uptimeMillis();
        if (this.shouldPropagateIntermediateResults(fetchState) && nowMs - fetchState.getLastIntermediateResultTimeMs() >= 100L) {
            fetchState.setLastIntermediateResultTimeMs(nowMs);
            fetchState.getListener().onProducerEvent(fetchState.getId(), PRODUCER_NAME, INTERMEDIATE_RESULT_PRODUCER_EVENT);
            this.notifyConsumer(pooledOutputStream, false, fetchState.getConsumer());
        }
    }

    private void handleFinalResult(PooledByteBufferOutputStream pooledOutputStream, FetchState fetchState) {
        Map<String, String> extraMap = this.getExtraMap(fetchState, pooledOutputStream.size());
        fetchState.getListener().onProducerFinishWithSuccess(fetchState.getId(), PRODUCER_NAME, extraMap);
        this.notifyConsumer(pooledOutputStream, true, fetchState.getConsumer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConsumer(PooledByteBufferOutputStream pooledOutputStream, boolean isFinal, Consumer<EncodedImage> consumer) {
        CloseableReference result = CloseableReference.of((Closeable)pooledOutputStream.toByteBuffer());
        EncodedImage encodedImage = null;
        try {
            encodedImage = new EncodedImage(result);
            encodedImage.parseMetaData();
            consumer.onNewResult(encodedImage, isFinal);
        }
        catch (Throwable throwable) {
            EncodedImage.closeSafely(encodedImage);
            CloseableReference.closeSafely((CloseableReference)result);
            throw throwable;
        }
        EncodedImage.closeSafely((EncodedImage)encodedImage);
        CloseableReference.closeSafely((CloseableReference)result);
    }

    private void onFailure(FetchState fetchState, Throwable e) {
        fetchState.getListener().onProducerFinishWithFailure(fetchState.getId(), PRODUCER_NAME, e, null);
        fetchState.getConsumer().onFailure(e);
    }

    private void onCancellation(FetchState fetchState) {
        fetchState.getListener().onProducerFinishWithCancellation(fetchState.getId(), PRODUCER_NAME, null);
        fetchState.getConsumer().onCancellation();
    }

    private boolean shouldPropagateIntermediateResults(FetchState fetchState) {
        if (!fetchState.getContext().getImageRequest().getProgressiveRenderingEnabled()) {
            return false;
        }
        return this.mNetworkFetcher.shouldPropagate(fetchState);
    }

    @Nullable
    private Map<String, String> getExtraMap(FetchState fetchState, int byteSize) {
        if (!fetchState.getListener().requiresExtraMap(fetchState.getId())) {
            return null;
        }
        return this.mNetworkFetcher.getExtraMap(fetchState, byteSize);
    }
}

