/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.request.ImageRequest;

public class DownsampleUtil {
    private static final float INTERVAL_ROUNDING = 0.33333334f;
    private static final int DEFAULT_SAMPLE_SIZE = 1;

    private DownsampleUtil() {
    }

    public static int determineSampleSize(ImageRequest imageRequest, EncodedImage encodedImage) {
        float maxBitmapSize;
        if (!EncodedImage.isMetaDataAvailable((EncodedImage)encodedImage)) {
            return 1;
        }
        float ratio = DownsampleUtil.determineDownsampleRatio(imageRequest, encodedImage);
        int sampleSize = encodedImage.getImageFormat() == DefaultImageFormats.JPEG ? DownsampleUtil.ratioToSampleSizeJPEG(ratio) : DownsampleUtil.ratioToSampleSize(ratio);
        int maxDimension = Math.max(encodedImage.getHeight(), encodedImage.getWidth());
        ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        float f = maxBitmapSize = resizeOptions != null ? resizeOptions.maxBitmapSize : 2048.0f;
        while ((float)(maxDimension / sampleSize) > maxBitmapSize) {
            if (encodedImage.getImageFormat() == DefaultImageFormats.JPEG) {
                sampleSize *= 2;
                continue;
            }
            ++sampleSize;
        }
        return sampleSize;
    }

    @VisibleForTesting
    static float determineDownsampleRatio(ImageRequest imageRequest, EncodedImage encodedImage) {
        Preconditions.checkArgument((boolean)EncodedImage.isMetaDataAvailable((EncodedImage)encodedImage));
        ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        if (resizeOptions == null || resizeOptions.height <= 0 || resizeOptions.width <= 0 || encodedImage.getWidth() == 0 || encodedImage.getHeight() == 0) {
            return 1.0f;
        }
        int rotationAngle = DownsampleUtil.getRotationAngle(imageRequest, encodedImage);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? encodedImage.getHeight() : encodedImage.getWidth();
        int heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight();
        float widthRatio = (float)resizeOptions.width / (float)widthAfterRotation;
        float heightRatio = (float)resizeOptions.height / (float)heightAfterRotation;
        float ratio = Math.max(widthRatio, heightRatio);
        FLog.v((String)"DownsampleUtil", (String)"Downsample - Specified size: %dx%d, image size: %dx%d ratio: %.1f x %.1f, ratio: %.3f for %s", (Object[])new Object[]{resizeOptions.width, resizeOptions.height, widthAfterRotation, heightAfterRotation, Float.valueOf(widthRatio), Float.valueOf(heightRatio), Float.valueOf(ratio), imageRequest.getSourceUri().toString()});
        return ratio;
    }

    @VisibleForTesting
    static int ratioToSampleSize(float ratio) {
        if (ratio > 0.6666667f) {
            return 1;
        }
        int sampleSize = 2;
        double intervalLength;
        double compare;
        while (!((compare = 1.0 / (double)sampleSize + (intervalLength = 1.0 / (Math.pow(sampleSize, 2.0) - (double)sampleSize)) * 0.3333333432674408) <= (double)ratio)) {
            ++sampleSize;
        }
        return sampleSize - 1;
    }

    @VisibleForTesting
    static int ratioToSampleSizeJPEG(float ratio) {
        if (ratio > 0.6666667f) {
            return 1;
        }
        int sampleSize = 2;
        double intervalLength;
        double compare;
        while (!((compare = 1.0 / (double)(2 * sampleSize) + (intervalLength = 1.0 / (double)(2 * sampleSize)) * 0.3333333432674408) <= (double)ratio)) {
            sampleSize *= 2;
        }
        return sampleSize;
    }

    private static int getRotationAngle(ImageRequest imageRequest, EncodedImage encodedImage) {
        if (!imageRequest.getRotationOptions().useImageMetadata()) {
            return 0;
        }
        int rotationAngle = encodedImage.getRotationAngle();
        Preconditions.checkArgument((rotationAngle == 0 || rotationAngle == 90 || rotationAngle == 180 || rotationAngle == 270 ? 1 : 0) != 0);
        return rotationAngle;
    }

    @VisibleForTesting
    static int roundToPowerOfTwo(int sampleSize) {
        int compare = 1;
        while (compare < sampleSize) {
            compare *= 2;
        }
        return compare;
    }
}

