/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.common.TooManyBitmapsException;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.imagepipeline.memory.BitmapCounterProvider;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import com.facebook.imagepipeline.platform.PlatformDecoder;

abstract class DalvikPurgeableDecoder
implements PlatformDecoder {
    protected static final byte[] EOI = new byte[]{-1, -39};
    private final BitmapCounter mUnpooledBitmapsCounter = BitmapCounterProvider.get();

    DalvikPurgeableDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig) {
        BitmapFactory.Options options = DalvikPurgeableDecoder.getBitmapFactoryOptions(encodedImage.getSampleSize(), bitmapConfig);
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            Bitmap bitmap = this.decodeByteArrayAsPurgeable((CloseableReference<PooledByteBuffer>)bytesRef, options);
            CloseableReference<Bitmap> closeableReference = this.pinBitmap(bitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig, int length) {
        BitmapFactory.Options options = DalvikPurgeableDecoder.getBitmapFactoryOptions(encodedImage.getSampleSize(), bitmapConfig);
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            Bitmap bitmap = this.decodeJPEGByteArrayAsPurgeable((CloseableReference<PooledByteBuffer>)bytesRef, length, options);
            CloseableReference<Bitmap> closeableReference = this.pinBitmap(bitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
    }

    abstract Bitmap decodeByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> var1, BitmapFactory.Options var2);

    abstract Bitmap decodeJPEGByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> var1, int var2, BitmapFactory.Options var3);

    private static BitmapFactory.Options getBitmapFactoryOptions(int sampleSize, Bitmap.Config bitmapConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = true;
        options.inPreferredConfig = bitmapConfig;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = sampleSize;
        if (Build.VERSION.SDK_INT >= 11) {
            options.inMutable = true;
        }
        return options;
    }

    protected static boolean endsWithEOI(CloseableReference<PooledByteBuffer> bytesRef, int length) {
        PooledByteBuffer buffer = (PooledByteBuffer)bytesRef.get();
        return length >= 2 && buffer.read(length - 2) == -1 && buffer.read(length - 1) == -39;
    }

    public CloseableReference<Bitmap> pinBitmap(Bitmap bitmap) {
        try {
            Bitmaps.pinBitmap(bitmap);
        }
        catch (Exception e) {
            bitmap.recycle();
            throw Throwables.propagate((Throwable)e);
        }
        if (!this.mUnpooledBitmapsCounter.increase(bitmap)) {
            bitmap.recycle();
            throw new TooManyBitmapsException();
        }
        return CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsCounter.getReleaser());
    }
}

