/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.cache.DiskCachePolicy;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;

public class DiskCacheWriteProducer
implements Producer<EncodedImage> {
    private final Producer<EncodedImage> mInputProducer;
    private final DiskCachePolicy mDiskCachePolicy;

    public DiskCacheWriteProducer(Producer<EncodedImage> inputProducer, DiskCachePolicy diskCachePolicy) {
        this.mInputProducer = inputProducer;
        this.mDiskCachePolicy = diskCachePolicy;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        this.maybeStartInputProducer(consumer, producerContext);
    }

    private void maybeStartInputProducer(Consumer<EncodedImage> consumerOfDiskCacheWriteProducer, ProducerContext producerContext) {
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.DISK_CACHE.getValue()) {
            consumerOfDiskCacheWriteProducer.onNewResult(null, true);
        } else {
            DiskCacheWriteConsumer consumer = producerContext.getImageRequest().isDiskCacheEnabled() ? new DiskCacheWriteConsumer(consumerOfDiskCacheWriteProducer, producerContext, this.mDiskCachePolicy) : consumerOfDiskCacheWriteProducer;
            this.mInputProducer.produceResults(consumer, producerContext);
        }
    }

    private static class DiskCacheWriteConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private final DiskCachePolicy mDiskCachePolicy;

        private DiskCacheWriteConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext, DiskCachePolicy diskCachePolicy) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mDiskCachePolicy = diskCachePolicy;
        }

        @Override
        public void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (newResult != null && isLast) {
                this.mDiskCachePolicy.writeToCache(newResult, this.mProducerContext.getImageRequest(), this.mProducerContext.getCallerContext());
            }
            this.getConsumer().onNewResult(newResult, isLast);
        }
    }
}

