/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.postprocessors;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.nativecode.NativeBlurFilter;
import com.facebook.imagepipeline.request.BasePostprocessor;
import java.util.Locale;
import javax.annotation.Nullable;

public class IterativeBoxBlurPostProcessor
extends BasePostprocessor {
    private static final int DEFAULT_ITERATIONS = 3;
    private final int mIterations;
    private final int mBlurRadius;
    private CacheKey mCacheKey;

    public IterativeBoxBlurPostProcessor(int blurRadius) {
        this(3, blurRadius);
    }

    public IterativeBoxBlurPostProcessor(int iterations, int blurRadius) {
        Preconditions.checkArgument((iterations > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((blurRadius > 0 ? 1 : 0) != 0);
        this.mIterations = iterations;
        this.mBlurRadius = blurRadius;
    }

    @Override
    public void process(Bitmap bitmap) {
        NativeBlurFilter.iterativeBoxBlur(bitmap, this.mIterations, this.mBlurRadius);
    }

    @Override
    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        if (this.mCacheKey == null) {
            String key = String.format((Locale)null, "i%dr%d", this.mIterations, this.mBlurRadius);
            this.mCacheKey = new SimpleCacheKey(key);
        }
        return this.mCacheKey;
    }
}

