/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.os.Build;
import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public abstract class LocalFetchProducer
implements Producer<EncodedImage> {
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final boolean mDecodeFileDescriptorEnabledForKitKat;

    protected LocalFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, boolean fileDescriptorEnabled) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mDecodeFileDescriptorEnabledForKitKat = fileDescriptorEnabled && Build.VERSION.SDK_INT == 19;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<EncodedImage> cancellableProducerRunnable = new StatefulProducerRunnable<EncodedImage>(consumer, listener, this.getProducerName(), requestId){

            protected EncodedImage getResult() throws Exception {
                EncodedImage encodedImage = LocalFetchProducer.this.getEncodedImage(imageRequest);
                if (encodedImage == null) {
                    return null;
                }
                encodedImage.parseMetaData();
                return encodedImage;
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely(result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EncodedImage getByteBufferBackedEncodedImage(InputStream inputStream, int length) throws IOException {
        EncodedImage encodedImage;
        CloseableReference ref = null;
        try {
            ref = length < 0 ? CloseableReference.of((Closeable)this.mPooledByteBufferFactory.newByteBuffer(inputStream)) : CloseableReference.of((Closeable)this.mPooledByteBufferFactory.newByteBuffer(inputStream, length));
            encodedImage = new EncodedImage((CloseableReference<PooledByteBuffer>)ref);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly((InputStream)inputStream);
            CloseableReference.closeSafely(ref);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)inputStream);
        CloseableReference.closeSafely((CloseableReference)ref);
        return encodedImage;
    }

    protected EncodedImage getEncodedImage(InputStream inputStream, int length) throws IOException {
        Runtime runTime = Runtime.getRuntime();
        long javaMax = runTime.maxMemory();
        long javaUsed = runTime.totalMemory() - runTime.freeMemory();
        long javaFree = Math.min(javaMax - javaUsed, 0x800000L);
        if (this.mDecodeFileDescriptorEnabledForKitKat && inputStream instanceof FileInputStream && javaMax >= 64L * javaFree) {
            return this.getInputStreamBackedEncodedImage(new File(inputStream.toString()), length);
        }
        return this.getByteBufferBackedEncodedImage(inputStream, length);
    }

    protected EncodedImage getInputStreamBackedEncodedImage(final File file, int length) throws IOException {
        Supplier<FileInputStream> sup = new Supplier<FileInputStream>(){

            public FileInputStream get() {
                try {
                    return new FileInputStream(file);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
        return new EncodedImage(sup, length);
    }

    protected abstract EncodedImage getEncodedImage(ImageRequest var1) throws IOException;

    protected abstract String getProducerName();
}

