/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.os.SystemClock;
import com.android.internal.util.Predicate;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.cache.CountingLruMap;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.imagepipeline.cache.ValueDescriptor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CountingMemoryCache<K, V>
implements MemoryCache<K, V>,
MemoryTrimmable {
    @VisibleForTesting
    static final long PARAMS_INTERCHECK_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, Entry<K, V>> mExclusiveEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, Entry<K, V>> mCachedEntries;
    private final ValueDescriptor<V> mValueDescriptor;
    private final CacheTrimStrategy mCacheTrimStrategy;
    private final Supplier<MemoryCacheParams> mMemoryCacheParamsSupplier;
    @GuardedBy(value="this")
    protected MemoryCacheParams mMemoryCacheParams;
    @GuardedBy(value="this")
    private long mLastCacheParamsCheck;

    public CountingMemoryCache(ValueDescriptor<V> valueDescriptor, CacheTrimStrategy cacheTrimStrategy, Supplier<MemoryCacheParams> memoryCacheParamsSupplier) {
        this.mValueDescriptor = valueDescriptor;
        this.mExclusiveEntries = new CountingLruMap<K, Entry<K, Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCachedEntries = new CountingLruMap<K, Entry<K, Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCacheTrimStrategy = cacheTrimStrategy;
        this.mMemoryCacheParamsSupplier = memoryCacheParamsSupplier;
        this.mMemoryCacheParams = (MemoryCacheParams)this.mMemoryCacheParamsSupplier.get();
        this.mLastCacheParamsCheck = SystemClock.elapsedRealtime();
    }

    private ValueDescriptor<Entry<K, V>> wrapValueDescriptor(final ValueDescriptor<V> evictableValueDescriptor) {
        return new ValueDescriptor<Entry<K, V>>(){

            @Override
            public int getSizeInBytes(Entry<K, V> entry) {
                return evictableValueDescriptor.getSizeInBytes(entry.valueRef.get());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(valueRef);
        this.maybeUpdateCacheParams();
        CloseableReference<V> oldRefToClose = null;
        CloseableReference<V> clientRef = null;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            this.mExclusiveEntries.remove(key);
            Entry<K, V> oldEntry = this.mCachedEntries.remove(key);
            if (oldEntry != null) {
                this.makeOrphan(oldEntry);
                oldRefToClose = this.referenceToClose(oldEntry);
            }
            if (this.canCacheNewValue(valueRef.get())) {
                Entry<K, V> newEntry = Entry.of(key, valueRef);
                this.mCachedEntries.put(key, newEntry);
                clientRef = this.newClientReference(newEntry);
            }
        }
        CloseableReference.closeSafely(oldRefToClose);
        this.maybeEvictEntries();
        return clientRef;
    }

    private synchronized boolean canCacheNewValue(V value) {
        int newValueSize = this.mValueDescriptor.getSizeInBytes(value);
        return newValueSize <= this.mMemoryCacheParams.maxCacheEntrySize && this.getInUseCount() + 1 <= this.mMemoryCacheParams.maxCacheEntries && this.getInUseSizeInBytes() + newValueSize <= this.mMemoryCacheParams.maxCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> get(K key) {
        CloseableReference<V> clientRef = null;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            this.mExclusiveEntries.remove(key);
            Entry<K, V> entry = this.mCachedEntries.get(key);
            if (entry != null) {
                clientRef = this.newClientReference(entry);
            }
        }
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return clientRef;
    }

    private synchronized CloseableReference<V> newClientReference(final Entry<K, V> entry) {
        this.increaseClientCount(entry);
        return CloseableReference.of((Object)entry.valueRef.get(), (ResourceReleaser)new ResourceReleaser<V>(){

            public void release(V unused) {
                CountingMemoryCache.this.releaseClientReference(entry);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseClientReference(Entry<K, V> entry) {
        CloseableReference<V> oldRefToClose;
        Preconditions.checkNotNull(entry);
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            this.decreaseClientCount(entry);
            this.maybeAddToExclusives(entry);
            oldRefToClose = this.referenceToClose(entry);
        }
        CloseableReference.closeSafely(oldRefToClose);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized void maybeAddToExclusives(Entry<K, V> entry) {
        if (!entry.isOrphan && entry.clientCount == 0) {
            this.mExclusiveEntries.put(entry.key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(Predicate<K> predicate) {
        ArrayList<Entry<K, V>> oldEntries;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            this.mExclusiveEntries.removeAll(predicate);
            oldEntries = this.mCachedEntries.removeAll(predicate);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return oldEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Entry<K, V>> oldEntries;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            this.mExclusiveEntries.clear();
            oldEntries = this.mCachedEntries.clear();
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeUpdateCacheParams();
    }

    @Override
    public synchronized boolean contains(Predicate<K> predicate) {
        return !this.mCachedEntries.getMatchingEntries(predicate).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(MemoryTrimType trimType) {
        ArrayList<Entry<K, V>> oldEntries;
        double trimRatio = this.mCacheTrimStrategy.getTrimRatio(trimType);
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            int targetCacheSize = (int)((double)this.mCachedEntries.getSizeInBytes() * (1.0 - trimRatio));
            int targetEvictionQueueSize = Math.max(0, targetCacheSize - this.getInUseSizeInBytes());
            oldEntries = this.trimExclusivelyOwnedEntries(Integer.MAX_VALUE, targetEvictionQueueSize);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized void maybeUpdateCacheParams() {
        if (this.mLastCacheParamsCheck + PARAMS_INTERCHECK_INTERVAL_MS > SystemClock.elapsedRealtime()) {
            return;
        }
        this.mLastCacheParamsCheck = SystemClock.elapsedRealtime();
        this.mMemoryCacheParams = (MemoryCacheParams)this.mMemoryCacheParamsSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictEntries() {
        ArrayList<Entry<K, V>> oldEntries;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            int maxCount = Math.min(this.mMemoryCacheParams.maxEvictionQueueEntries, this.mMemoryCacheParams.maxCacheEntries - this.getInUseCount());
            int maxSize = Math.min(this.mMemoryCacheParams.maxEvictionQueueSize, this.mMemoryCacheParams.maxCacheSize - this.getInUseSizeInBytes());
            oldEntries = this.trimExclusivelyOwnedEntries(maxCount, maxSize);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
    }

    @Nullable
    private synchronized ArrayList<Entry<K, V>> trimExclusivelyOwnedEntries(int count, int size) {
        count = Math.max(count, 0);
        size = Math.max(size, 0);
        if (this.mExclusiveEntries.getCount() <= count && this.mExclusiveEntries.getSizeInBytes() <= size) {
            return null;
        }
        ArrayList<Entry<K, V>> oldEntries = new ArrayList<Entry<K, V>>();
        while (this.mExclusiveEntries.getCount() > count || this.mExclusiveEntries.getSizeInBytes() > size) {
            K key = this.mExclusiveEntries.getFirstKey();
            this.mExclusiveEntries.remove(key);
            oldEntries.add(this.mCachedEntries.remove(key));
        }
        return oldEntries;
    }

    private void maybeClose(@Nullable ArrayList<Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (Entry<K, V> oldEntry : oldEntries) {
                CloseableReference.closeSafely(this.referenceToClose(oldEntry));
            }
        }
    }

    private synchronized void makeOrphans(@Nullable ArrayList<Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (Entry<K, V> oldEntry : oldEntries) {
                this.makeOrphan(oldEntry);
            }
        }
    }

    private synchronized void makeOrphan(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        entry.isOrphan = true;
    }

    private synchronized void increaseClientCount(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        ++entry.clientCount;
    }

    private synchronized void decreaseClientCount(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((entry.clientCount > 0 ? 1 : 0) != 0);
        --entry.clientCount;
    }

    @Nullable
    private synchronized CloseableReference<V> referenceToClose(Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return entry.isOrphan && entry.clientCount == 0 ? entry.valueRef : null;
    }

    public synchronized int getCount() {
        return this.mCachedEntries.getCount();
    }

    public synchronized int getSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes();
    }

    public synchronized int getInUseCount() {
        return this.mCachedEntries.getCount() - this.mExclusiveEntries.getCount();
    }

    public synchronized int getInUseSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes() - this.mExclusiveEntries.getSizeInBytes();
    }

    public synchronized int getEvictionQueueCount() {
        return this.mExclusiveEntries.getCount();
    }

    public synchronized int getEvictionQueueSizeInBytes() {
        return this.mExclusiveEntries.getSizeInBytes();
    }

    @VisibleForTesting
    static class Entry<K, V> {
        public final K key;
        public final CloseableReference<V> valueRef;
        public int clientCount;
        public boolean isOrphan;

        private Entry(K key, CloseableReference<V> valueRef) {
            this.key = Preconditions.checkNotNull(key);
            this.valueRef = (CloseableReference)Preconditions.checkNotNull((Object)CloseableReference.cloneOrNull(valueRef));
            this.clientCount = 0;
            this.isOrphan = false;
        }

        @VisibleForTesting
        static <K, V> Entry<K, V> of(K key, CloseableReference<V> valueRef) {
            return new Entry<K, V>(key, valueRef);
        }
    }

    public static interface CacheTrimStrategy {
        public double getTrimRatio(MemoryTrimType var1);
    }
}

