/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;

public final class BitmapUtil {
    @SuppressLint(value={"NewApi"})
    public static int getSizeInBytes(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getWidth() * bitmap.getRowBytes();
    }

    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(byte[] bytes) {
        return BitmapUtil.decodeDimensions(new ByteArrayInputStream(bytes));
    }

    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(InputStream is) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        return options.outWidth == -1 || options.outHeight == -1 ? null : new Pair((Object)options.outWidth, (Object)options.outHeight);
    }
}

