/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import com.android.internal.util.Predicate;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.DiskStorageCache;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSources;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheKey;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.core.ProducerSequenceFactory;
import com.facebook.imagepipeline.datasource.CloseableProducerToDataSourceAdapter;
import com.facebook.imagepipeline.datasource.ProducerToDataSourceAdapter;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.listener.ForwardingRequestListener;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ImagePipeline {
    private static final CancellationException PREFETCH_EXCEPTION = new CancellationException("Prefetching is not enabled");
    private final ProducerSequenceFactory mProducerSequenceFactory;
    private final RequestListener mRequestListener;
    private final Supplier<Boolean> mIsPrefetchEnabledSupplier;
    private final MemoryCache<CacheKey, CloseableImage> mBitmapMemoryCache;
    private final MemoryCache<CacheKey, PooledByteBuffer> mEncodedMemoryCache;
    private final DiskStorageCache mMainDiskStorageCache;
    private final DiskStorageCache mSmallImageDiskStorageCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private AtomicLong mIdCounter = new AtomicLong();

    public ImagePipeline(ProducerSequenceFactory producerSequenceFactory, Set<RequestListener> requestListeners, Supplier<Boolean> isPrefetchEnabledSupplier, MemoryCache<CacheKey, CloseableImage> bitmapMemoryCache, MemoryCache<CacheKey, PooledByteBuffer> encodedMemoryCache, DiskStorageCache mainDiskStorageCache, DiskStorageCache smallImageDiskStorageCache, CacheKeyFactory cacheKeyFactory) {
        this.mProducerSequenceFactory = producerSequenceFactory;
        this.mRequestListener = new ForwardingRequestListener(requestListeners);
        this.mIsPrefetchEnabledSupplier = isPrefetchEnabledSupplier;
        this.mBitmapMemoryCache = bitmapMemoryCache;
        this.mEncodedMemoryCache = encodedMemoryCache;
        this.mMainDiskStorageCache = mainDiskStorageCache;
        this.mSmallImageDiskStorageCache = smallImageDiskStorageCache;
        this.mCacheKeyFactory = cacheKeyFactory;
    }

    private String generateUniqueFutureId() {
        return String.valueOf(this.mIdCounter.getAndIncrement());
    }

    public Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext, final boolean bitmapCacheOnly) {
        return new Supplier<DataSource<CloseableReference<CloseableImage>>>(){

            public DataSource<CloseableReference<CloseableImage>> get() {
                if (bitmapCacheOnly) {
                    return ImagePipeline.this.fetchImageFromBitmapCache(imageRequest, callerContext);
                }
                return ImagePipeline.this.fetchDecodedImage(imageRequest, callerContext);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public DataSource<CloseableReference<CloseableImage>> fetchImageFromBitmapCache(ImageRequest imageRequest, Object callerContext) {
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getDecodedImageProducerSequence(imageRequest);
            return this.submitFetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext) {
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getDecodedImageProducerSequence(imageRequest);
            return this.submitFetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<CloseableReference<PooledByteBuffer>> fetchEncodedImage(ImageRequest imageRequest, Object callerContext) {
        Preconditions.checkNotNull((Object)imageRequest.getSourceUri());
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getEncodedImageProducerSequence(imageRequest);
            if (imageRequest.getResizeOptions() != null) {
                imageRequest = ImageRequestBuilder.fromRequest(imageRequest).setResizeOptions(null).build();
            }
            return this.submitFetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<Void> prefetchToBitmapCache(ImageRequest imageRequest, Object callerContext) {
        if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
            return DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
        }
        try {
            Producer<Void> producerSequence = this.mProducerSequenceFactory.getDecodedImagePrefetchProducerSequence(imageRequest);
            return this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext) {
        if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
            return DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
        }
        try {
            Producer<Void> producerSequence = this.mProducerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
            return this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public void evictFromMemoryCache(Uri uri) {
        final String cacheKeySourceString = this.mCacheKeyFactory.getCacheKeySourceUri(uri).toString();
        Predicate<CacheKey> bitmapCachePredicate = new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                if (key instanceof BitmapMemoryCacheKey) {
                    return ((BitmapMemoryCacheKey)key).getSourceUriString().equals(cacheKeySourceString);
                }
                return false;
            }
        };
        this.mBitmapMemoryCache.removeAll(bitmapCachePredicate);
        Predicate<CacheKey> encodedCachePredicate = new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                return key.toString().equals(cacheKeySourceString);
            }
        };
        this.mEncodedMemoryCache.removeAll(encodedCachePredicate);
    }

    public void evictFromDiskCache(Uri uri) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(ImageRequest.fromUri(uri));
        this.mMainDiskStorageCache.remove(cacheKey);
        this.mSmallImageDiskStorageCache.remove(cacheKey);
    }

    public void evictFromDiskCache(ImageRequest imageRequest) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest);
        this.mMainDiskStorageCache.remove(cacheKey);
        this.mSmallImageDiskStorageCache.remove(cacheKey);
    }

    public void evictFromCache(Uri uri) {
        this.evictFromMemoryCache(uri);
        this.evictFromDiskCache(uri);
    }

    public void clearMemoryCaches() {
        Predicate<CacheKey> allPredicate = new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                return true;
            }
        };
        this.mBitmapMemoryCache.removeAll(allPredicate);
        this.mEncodedMemoryCache.removeAll(allPredicate);
    }

    public void clearDiskCaches() {
        this.mMainDiskStorageCache.clearAll();
        this.mSmallImageDiskStorageCache.clearAll();
    }

    public void clearCaches() {
        this.clearMemoryCaches();
        this.clearDiskCaches();
    }

    private <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext) {
        try {
            ImageRequest.RequestLevel lowestPermittedRequestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), this.mRequestListener, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority());
            return CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, this.mRequestListener);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    private DataSource<Void> submitPrefetchRequest(Producer<Void> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext) {
        try {
            ImageRequest.RequestLevel lowestPermittedRequestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), this.mRequestListener, callerContext, lowestPermittedRequestLevel, true, false, Priority.LOW);
            return ProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, this.mRequestListener);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }
}

