/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imageutils.JfifUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class LocalContentUriFetchProducer
extends LocalFetchProducer {
    private static final Class<?> TAG = LocalContentUriFetchProducer.class;
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalContentUriFetchProducer";
    private static final String DISPLAY_PHOTO_PATH = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"display_photo").getPath();
    private static final String[] PROJECTION = new String[]{"_id", "_data"};
    private static final String[] THUMBNAIL_PROJECTION = new String[]{"_data"};
    private static final Rect MINI_THUMBNAIL_DIMENSIONS = new Rect(0, 0, 512, 384);
    private static final Rect MICRO_THUMBNAIL_DIMENSIONS = new Rect(0, 0, 96, 96);
    private static final float ACCEPTABLE_REQUESTED_TO_ACTUAL_SIZE_RATIO = 1.3333334f;
    private static final int NO_THUMBNAIL = 0;
    private final ContentResolver mContentResolver;

    public LocalContentUriFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, boolean downsampleEnabled, ContentResolver contentResolver) {
        super(executor, pooledByteBufferFactory, downsampleEnabled);
        this.mContentResolver = contentResolver;
    }

    @Override
    protected EncodedImage getEncodedImage(ImageRequest imageRequest) throws IOException {
        EncodedImage cameraImage;
        Uri uri = imageRequest.getSourceUri();
        if (LocalContentUriFetchProducer.isContactUri(uri)) {
            return this.getByteBufferBackedEncodedImage(ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.mContentResolver, (Uri)uri), -1);
        }
        if (LocalContentUriFetchProducer.isCameraUri(uri) && (cameraImage = this.getCameraImage(uri, imageRequest.getResizeOptions())) != null) {
            return cameraImage;
        }
        return this.getByteBufferBackedEncodedImage(this.mContentResolver.openInputStream(uri), -1);
    }

    private static boolean isContactUri(Uri uri) {
        return "com.android.contacts".equals(uri.getAuthority()) && !uri.getPath().startsWith(DISPLAY_PHOTO_PATH);
    }

    private static boolean isCameraUri(Uri uri) {
        String uriString = uri.toString();
        return uriString.startsWith(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString()) || uriString.startsWith(MediaStore.Images.Media.INTERNAL_CONTENT_URI.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EncodedImage getCameraImage(Uri uri, ResizeOptions resizeOptions) {
        Cursor cursor = this.mContentResolver.query(uri, PROJECTION, null, null, null);
        if (cursor == null) {
            return null;
        }
        try {
            int imageIdColumnIndex;
            EncodedImage thumbnail;
            if (cursor.getCount() == 0) {
                EncodedImage encodedImage = null;
                return encodedImage;
            }
            cursor.moveToFirst();
            String pathname = cursor.getString(cursor.getColumnIndex("_data"));
            if (resizeOptions != null && (thumbnail = this.getThumbnail(resizeOptions, cursor.getInt(imageIdColumnIndex = cursor.getColumnIndex("_id")))) != null) {
                thumbnail.setRotationAngle(LocalContentUriFetchProducer.getRotationAngle(pathname));
                EncodedImage encodedImage = thumbnail;
                return encodedImage;
            }
            if (pathname != null) {
                EncodedImage encodedImage = this.getFileBackedEncodedImage(pathname, LocalContentUriFetchProducer.getLength(pathname));
                return encodedImage;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncodedImage getThumbnail(ResizeOptions resizeOptions, int imageId) {
        int thumbnailKind = LocalContentUriFetchProducer.getThumbnailKind(resizeOptions);
        if (thumbnailKind == 0) {
            return null;
        }
        try (Cursor thumbnailCursor = null;){
            String thumbnailUri;
            thumbnailCursor = MediaStore.Images.Thumbnails.queryMiniThumbnail((ContentResolver)this.mContentResolver, (long)imageId, (int)thumbnailKind, (String[])THUMBNAIL_PROJECTION);
            if (thumbnailCursor == null) {
                EncodedImage encodedImage = null;
                return encodedImage;
            }
            thumbnailCursor.moveToFirst();
            if (thumbnailCursor.getCount() > 0 && new File(thumbnailUri = thumbnailCursor.getString(thumbnailCursor.getColumnIndex("_data"))).exists()) {
                EncodedImage encodedImage = this.getFileBackedEncodedImage(thumbnailUri, LocalContentUriFetchProducer.getLength(thumbnailUri));
                return encodedImage;
            }
        }
        return null;
    }

    private static int getThumbnailKind(ResizeOptions resizeOptions) {
        if (LocalContentUriFetchProducer.isThumbnailBigEnough(resizeOptions, MICRO_THUMBNAIL_DIMENSIONS)) {
            return 3;
        }
        if (LocalContentUriFetchProducer.isThumbnailBigEnough(resizeOptions, MINI_THUMBNAIL_DIMENSIONS)) {
            return 1;
        }
        return 0;
    }

    @VisibleForTesting
    static boolean isThumbnailBigEnough(ResizeOptions resizeOptions, Rect thumbnailDimensions) {
        return (float)resizeOptions.width <= (float)thumbnailDimensions.width() * 1.3333334f && (float)resizeOptions.height <= (float)thumbnailDimensions.height() * 1.3333334f;
    }

    private static int getLength(String pathname) {
        return pathname == null ? -1 : (int)new File(pathname).length();
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static int getRotationAngle(String pathname) {
        if (pathname != null) {
            try {
                ExifInterface exif = new ExifInterface(pathname);
                return JfifUtil.getAutoRotateAngleFromOrientation(exif.getAttributeInt("Orientation", 1));
            }
            catch (IOException ioe) {
                FLog.e(TAG, (Throwable)ioe, (String)"Unable to retrieve thumbnail rotation for %s", (Object[])new Object[]{pathname});
            }
        }
        return 0;
    }
}

