/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.nativecode.WebpTranscoder;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class WebpTranscodeProducer
implements Producer<EncodedImage> {
    private static final String PRODUCER_NAME = "WebpTranscodeProducer";
    private static final int DEFAULT_JPEG_QUALITY = 80;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<EncodedImage> mNextProducer;

    public WebpTranscodeProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<EncodedImage> nextProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new WebpTranscodeConsumer(consumer, context), context);
    }

    private void transcodeLastResult(EncodedImage originalResult, Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        Preconditions.checkNotNull((Object)originalResult);
        final EncodedImage encodedImageCopy = EncodedImage.cloneOrNull(originalResult);
        StatefulProducerRunnable<EncodedImage> runnable = new StatefulProducerRunnable<EncodedImage>(consumer, producerContext.getListener(), PRODUCER_NAME, producerContext.getId()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected EncodedImage getResult() throws Exception {
                try (PooledByteBufferOutputStream outputStream = WebpTranscodeProducer.this.mPooledByteBufferFactory.newOutputStream();){
                    EncodedImage encodedImage;
                    WebpTranscodeProducer.doTranscode(encodedImageCopy, outputStream);
                    CloseableReference ref = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                    try {
                        encodedImage = new EncodedImage((CloseableReference<PooledByteBuffer>)ref);
                    }
                    catch (Throwable throwable) {
                        CloseableReference.closeSafely((CloseableReference)ref);
                        throw throwable;
                    }
                    CloseableReference.closeSafely((CloseableReference)ref);
                    return encodedImage;
                }
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely(result);
            }

            @Override
            protected void onSuccess(EncodedImage result) {
                EncodedImage.closeSafely(encodedImageCopy);
                super.onSuccess(result);
            }

            @Override
            protected void onFailure(Exception e) {
                EncodedImage.closeSafely(encodedImageCopy);
                super.onFailure(e);
            }

            @Override
            protected void onCancellation() {
                EncodedImage.closeSafely(encodedImageCopy);
                super.onCancellation();
            }
        };
        this.mExecutor.execute((Runnable)((Object)runnable));
    }

    private static TriState shouldTranscode(EncodedImage encodedImage) {
        Preconditions.checkNotNull((Object)encodedImage);
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(encodedImage.getInputStream());
        switch (imageFormat) {
            case WEBP_SIMPLE: 
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                return TriState.valueOf((!WebpTranscoder.isWebpNativelySupported(imageFormat) ? 1 : 0) != 0);
            }
            case UNKNOWN: {
                return TriState.UNSET;
            }
        }
        return TriState.NO;
    }

    private static void doTranscode(EncodedImage encodedImage, PooledByteBufferOutputStream outputStream) throws Exception {
        InputStream imageInputStream = encodedImage.getInputStream();
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(imageInputStream);
        switch (imageFormat) {
            case WEBP_SIMPLE: 
            case WEBP_EXTENDED: {
                WebpTranscoder.transcodeWebpToJpeg(imageInputStream, outputStream, 80);
                break;
            }
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                WebpTranscoder.transcodeWebpToPng(imageInputStream, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image format");
            }
        }
    }

    private class WebpTranscodeConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mContext;
        private TriState mShouldTranscodeWhenFinished;

        public WebpTranscodeConsumer(Consumer<EncodedImage> consumer, ProducerContext context) {
            super(consumer);
            this.mContext = context;
            this.mShouldTranscodeWhenFinished = TriState.UNSET;
        }

        @Override
        protected void onNewResultImpl(@Nullable EncodedImage newResult, boolean isLast) {
            if (this.mShouldTranscodeWhenFinished == TriState.UNSET && newResult != null) {
                this.mShouldTranscodeWhenFinished = WebpTranscodeProducer.shouldTranscode(newResult);
            }
            if (this.mShouldTranscodeWhenFinished == TriState.NO) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            if (isLast) {
                if (this.mShouldTranscodeWhenFinished == TriState.YES && newResult != null) {
                    WebpTranscodeProducer.this.transcodeLastResult(newResult, this.getConsumer(), this.mContext);
                } else {
                    this.getConsumer().onNewResult(newResult, isLast);
                }
            }
        }
    }
}

