/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DiskCacheProducer
implements Producer<EncodedImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "DiskCacheProducer";
    @VisibleForTesting
    static final String VALUE_FOUND = "cached_value_found";
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<EncodedImage> mNextProducer;

    public DiskCacheProducer(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, Producer<EncodedImage> nextProducer) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(final Consumer<EncodedImage> consumer, final ProducerContext producerContext) {
        ImageRequest imageRequest = producerContext.getImageRequest();
        if (!imageRequest.isDiskCacheEnabled()) {
            this.maybeStartNextProducer(consumer, consumer, producerContext);
            return;
        }
        final ProducerListener listener = producerContext.getListener();
        final String requestId = producerContext.getId();
        listener.onProducerStart(requestId, PRODUCER_NAME);
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest);
        final BufferedDiskCache cache = imageRequest.getImageType() == ImageRequest.ImageType.SMALL ? this.mSmallImageBufferedDiskCache : this.mDefaultBufferedDiskCache;
        Continuation<EncodedImage, Void> continuation = new Continuation<EncodedImage, Void>(){

            public Void then(Task<EncodedImage> task) throws Exception {
                if (task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException) {
                    listener.onProducerFinishWithCancellation(requestId, DiskCacheProducer.PRODUCER_NAME, null);
                    consumer.onCancellation();
                } else if (task.isFaulted()) {
                    listener.onProducerFinishWithFailure(requestId, DiskCacheProducer.PRODUCER_NAME, task.getError(), null);
                    DiskCacheProducer.this.maybeStartNextProducer(consumer, new DiskCacheConsumer(consumer, cache, cacheKey), producerContext);
                } else {
                    EncodedImage cachedReference = (EncodedImage)task.getResult();
                    if (cachedReference != null) {
                        listener.onProducerFinishWithSuccess(requestId, DiskCacheProducer.PRODUCER_NAME, DiskCacheProducer.getExtraMap(listener, requestId, true));
                        consumer.onProgressUpdate(1.0f);
                        consumer.onNewResult(cachedReference, true);
                        cachedReference.close();
                    } else {
                        listener.onProducerFinishWithSuccess(requestId, DiskCacheProducer.PRODUCER_NAME, DiskCacheProducer.getExtraMap(listener, requestId, false));
                        DiskCacheProducer.this.maybeStartNextProducer(consumer, new DiskCacheConsumer(consumer, cache, cacheKey), producerContext);
                    }
                }
                return null;
            }
        };
        AtomicBoolean isCancelled = new AtomicBoolean(false);
        Task<EncodedImage> diskCacheLookupTask = cache.get(cacheKey, isCancelled);
        diskCacheLookupTask.continueWith((Continuation)continuation);
        this.subscribeTaskForRequestCancellation(isCancelled, producerContext);
    }

    private void maybeStartNextProducer(Consumer<EncodedImage> consumerOfDiskCacheProducer, Consumer<EncodedImage> consumerOfNextProducer, ProducerContext producerContext) {
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.DISK_CACHE.getValue()) {
            consumerOfDiskCacheProducer.onNewResult(null, true);
            return;
        }
        this.mNextProducer.produceResults(consumerOfNextProducer, producerContext);
    }

    @VisibleForTesting
    static Map<String, String> getExtraMap(ProducerListener listener, String requestId, boolean valueFound) {
        if (!listener.requiresExtraMap(requestId)) {
            return null;
        }
        return ImmutableMap.of((Object)VALUE_FOUND, (Object)String.valueOf(valueFound));
    }

    private void subscribeTaskForRequestCancellation(final AtomicBoolean isCancelled, ProducerContext producerContext) {
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                isCancelled.set(true);
            }
        });
    }

    private class DiskCacheConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final BufferedDiskCache mCache;
        private final CacheKey mCacheKey;

        private DiskCacheConsumer(Consumer<EncodedImage> consumer, BufferedDiskCache cache, CacheKey cacheKey) {
            super(consumer);
            this.mCache = cache;
            this.mCacheKey = cacheKey;
        }

        @Override
        public void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (newResult != null && isLast) {
                this.mCache.put(this.mCacheKey, newResult);
            }
            this.getConsumer().onNewResult(newResult, isLast);
        }
    }
}

