/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.nativecode.WebpTranscoder;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import java.io.Closeable;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class WebpTranscodeProducer
implements Producer<CloseableReference<PooledByteBuffer>> {
    private static final String PRODUCER_NAME = "WebpTranscodeProducer";
    private static final int DEFAULT_JPEG_QUALITY = 80;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public WebpTranscodeProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new WebpTranscodeConsumer(consumer, context), context);
    }

    private void transcodeLastResult(CloseableReference<PooledByteBuffer> originalResult, Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext producerContext) {
        Preconditions.checkNotNull(originalResult);
        final CloseableReference imageRefCopy = originalResult.clone();
        StatefulProducerRunnable<CloseableReference<PooledByteBuffer>> runnable = new StatefulProducerRunnable<CloseableReference<PooledByteBuffer>>(consumer, producerContext.getListener(), PRODUCER_NAME, producerContext.getId()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CloseableReference<PooledByteBuffer> getResult() throws Exception {
                try (PooledByteBufferOutputStream outputStream = WebpTranscodeProducer.this.mPooledByteBufferFactory.newOutputStream();){
                    WebpTranscodeProducer.doTranscode((CloseableReference<PooledByteBuffer>)imageRefCopy, outputStream);
                    CloseableReference closeableReference = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                    return closeableReference;
                }
            }

            @Override
            protected void disposeResult(CloseableReference<PooledByteBuffer> result) {
                CloseableReference.closeSafely(result);
            }

            @Override
            protected void onSuccess(CloseableReference<PooledByteBuffer> result) {
                imageRefCopy.close();
                super.onSuccess(result);
            }

            @Override
            protected void onFailure(Exception e) {
                imageRefCopy.close();
                super.onFailure(e);
            }

            @Override
            protected void onCancellation() {
                imageRefCopy.close();
                super.onCancellation();
            }
        };
        this.mExecutor.execute((Runnable)((Object)runnable));
    }

    private static TriState shouldTranscode(CloseableReference<PooledByteBuffer> imageRef) {
        Preconditions.checkNotNull(imageRef);
        PooledByteBufferInputStream imageInputStream = new PooledByteBufferInputStream((PooledByteBuffer)imageRef.get());
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(imageInputStream);
        switch (imageFormat) {
            case WEBP_SIMPLE: 
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                return TriState.valueOf((!WebpTranscoder.isWebpNativelySupported(imageFormat) ? 1 : 0) != 0);
            }
            case UNKNOWN: {
                return TriState.UNSET;
            }
        }
        return TriState.NO;
    }

    private static void doTranscode(CloseableReference<PooledByteBuffer> imageRef, PooledByteBufferOutputStream outputStream) throws Exception {
        PooledByteBufferInputStream imageInputStream = new PooledByteBufferInputStream((PooledByteBuffer)imageRef.get());
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(imageInputStream);
        switch (imageFormat) {
            case WEBP_SIMPLE: 
            case WEBP_EXTENDED: {
                WebpTranscoder.transcodeWebpToJpeg(imageInputStream, outputStream, 80);
                break;
            }
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                WebpTranscoder.transcodeWebpToPng(imageInputStream, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image format");
            }
        }
    }

    private class WebpTranscodeConsumer
    extends DelegatingConsumer<CloseableReference<PooledByteBuffer>, CloseableReference<PooledByteBuffer>> {
        private final ProducerContext mContext;
        private TriState mShouldTranscodeWhenFinished;

        public WebpTranscodeConsumer(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext context) {
            super(consumer);
            this.mContext = context;
            this.mShouldTranscodeWhenFinished = TriState.UNSET;
        }

        @Override
        protected void onNewResultImpl(@Nullable CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            if (this.mShouldTranscodeWhenFinished == TriState.UNSET && newResult != null) {
                this.mShouldTranscodeWhenFinished = WebpTranscodeProducer.shouldTranscode((CloseableReference<PooledByteBuffer>)newResult);
            }
            if (this.mShouldTranscodeWhenFinished == TriState.NO) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            if (isLast) {
                if (this.mShouldTranscodeWhenFinished == TriState.YES && newResult != null) {
                    WebpTranscodeProducer.this.transcodeLastResult((CloseableReference<PooledByteBuffer>)newResult, this.getConsumer(), this.mContext);
                } else {
                    this.getConsumer().onNewResult(newResult, isLast);
                }
            }
        }
    }
}

