/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.imagepipeline.request.RepeatedPostprocessor;
import com.facebook.imagepipeline.request.RepeatedPostprocessorRunner;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class PostprocessorProducer
implements Producer<CloseableReference<CloseableImage>> {
    @VisibleForTesting
    static final String NAME = "PostprocessorProducer";
    @VisibleForTesting
    static final String POSTPROCESSOR = "Postprocessor";
    private final Producer<CloseableReference<CloseableImage>> mNextProducer;
    private final PlatformBitmapFactory mBitmapFactory;
    private final Executor mExecutor;

    public PostprocessorProducer(Producer<CloseableReference<CloseableImage>> nextProducer, PlatformBitmapFactory platformBitmapFactory, Executor executor) {
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
        this.mBitmapFactory = platformBitmapFactory;
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext context) {
        ProducerListener listener = context.getListener();
        Postprocessor postprocessor = context.getImageRequest().getPostprocessor();
        PostprocessorConsumer basePostprocessorConsumer = new PostprocessorConsumer(consumer, listener, context.getId(), postprocessor, context);
        DelegatingConsumer postprocessorConsumer = postprocessor instanceof RepeatedPostprocessor ? new RepeatedPostprocessorConsumer(basePostprocessorConsumer, (RepeatedPostprocessor)postprocessor, context) : new SingleUsePostprocessorConsumer(basePostprocessorConsumer);
        this.mNextProducer.produceResults(postprocessorConsumer, context);
    }

    class RepeatedPostprocessorConsumer
    extends DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>>
    implements RepeatedPostprocessorRunner {
        @GuardedBy(value="RepeatedPostprocessorConsumer.this")
        private boolean mIsClosed;
        @Nullable
        @GuardedBy(value="RepeatedPostprocessorConsumer.this")
        private CloseableReference<CloseableImage> mSourceImageRef;

        private RepeatedPostprocessorConsumer(PostprocessorConsumer postprocessorConsumer, RepeatedPostprocessor repeatedPostprocessor, ProducerContext context) {
            super(postprocessorConsumer);
            this.mIsClosed = false;
            this.mSourceImageRef = null;
            repeatedPostprocessor.setCallback(this);
            context.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onCancellationRequested() {
                    if (RepeatedPostprocessorConsumer.this.close()) {
                        RepeatedPostprocessorConsumer.this.getConsumer().onCancellation();
                    }
                }
            });
        }

        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, boolean isLast) {
            if (!isLast) {
                return;
            }
            this.setSourceImageRef(newResult);
            this.updateInternal();
        }

        @Override
        protected void onFailureImpl(Throwable throwable) {
            if (this.close()) {
                this.getConsumer().onFailure(throwable);
            }
        }

        @Override
        protected void onCancellationImpl() {
            if (this.close()) {
                this.getConsumer().onCancellation();
            }
        }

        @Override
        public synchronized void update() {
            this.updateInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateInternal() {
            CloseableReference sourceImageRef;
            RepeatedPostprocessorConsumer repeatedPostprocessorConsumer = this;
            synchronized (repeatedPostprocessorConsumer) {
                if (this.mIsClosed) {
                    return;
                }
                sourceImageRef = CloseableReference.cloneOrNull(this.mSourceImageRef);
            }
            try {
                this.getConsumer().onNewResult(sourceImageRef, false);
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)sourceImageRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSourceImageRef(CloseableReference<CloseableImage> sourceImageRef) {
            CloseableReference<CloseableImage> oldSourceImageRef;
            RepeatedPostprocessorConsumer repeatedPostprocessorConsumer = this;
            synchronized (repeatedPostprocessorConsumer) {
                if (this.mIsClosed) {
                    return;
                }
                oldSourceImageRef = this.mSourceImageRef;
                this.mSourceImageRef = CloseableReference.cloneOrNull(sourceImageRef);
            }
            CloseableReference.closeSafely(oldSourceImageRef);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean close() {
            CloseableReference<CloseableImage> oldSourceImageRef;
            RepeatedPostprocessorConsumer repeatedPostprocessorConsumer = this;
            synchronized (repeatedPostprocessorConsumer) {
                if (this.mIsClosed) {
                    return false;
                }
                oldSourceImageRef = this.mSourceImageRef;
                this.mSourceImageRef = null;
                this.mIsClosed = true;
            }
            CloseableReference.closeSafely(oldSourceImageRef);
            return true;
        }
    }

    class SingleUsePostprocessorConsumer
    extends DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>> {
        private SingleUsePostprocessorConsumer(PostprocessorConsumer postprocessorConsumer) {
            super(postprocessorConsumer);
        }

        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, boolean isLast) {
            if (!isLast) {
                return;
            }
            this.getConsumer().onNewResult(newResult, isLast);
        }
    }

    private class PostprocessorConsumer
    extends DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>> {
        private final ProducerListener mListener;
        private final String mRequestId;
        private final Postprocessor mPostprocessor;
        @GuardedBy(value="PostprocessorConsumer.this")
        private boolean mIsClosed;
        @Nullable
        @GuardedBy(value="PostprocessorConsumer.this")
        private CloseableReference<CloseableImage> mSourceImageRef;
        @GuardedBy(value="PostprocessorConsumer.this")
        private boolean mIsLast;
        @GuardedBy(value="PostprocessorConsumer.this")
        private boolean mIsDirty;
        @GuardedBy(value="PostprocessorConsumer.this")
        private boolean mIsPostProcessingRunning;

        public PostprocessorConsumer(Consumer<CloseableReference<CloseableImage>> consumer, ProducerListener listener, String requestId, Postprocessor postprocessor, ProducerContext producerContext) {
            super(consumer);
            this.mSourceImageRef = null;
            this.mIsLast = false;
            this.mIsDirty = false;
            this.mIsPostProcessingRunning = false;
            this.mListener = listener;
            this.mRequestId = requestId;
            this.mPostprocessor = postprocessor;
            producerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onCancellationRequested() {
                    PostprocessorConsumer.this.maybeNotifyOnCancellation();
                }
            });
        }

        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, boolean isLast) {
            if (!CloseableReference.isValid(newResult)) {
                if (isLast) {
                    this.maybeNotifyOnNewResult(null, true);
                }
                return;
            }
            this.updateSourceImageRef(newResult, isLast);
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            this.maybeNotifyOnFailure(t);
        }

        @Override
        protected void onCancellationImpl() {
            this.maybeNotifyOnCancellation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSourceImageRef(@Nullable CloseableReference<CloseableImage> sourceImageRef, boolean isLast) {
            boolean shouldSubmit;
            CloseableReference<CloseableImage> oldSourceImageRef;
            PostprocessorConsumer postprocessorConsumer = this;
            synchronized (postprocessorConsumer) {
                if (this.mIsClosed) {
                    return;
                }
                oldSourceImageRef = this.mSourceImageRef;
                this.mSourceImageRef = CloseableReference.cloneOrNull(sourceImageRef);
                this.mIsLast = isLast;
                this.mIsDirty = true;
                shouldSubmit = this.setRunningIfDirtyAndNotRunning();
            }
            CloseableReference.closeSafely(oldSourceImageRef);
            if (shouldSubmit) {
                this.submitPostprocessing();
            }
        }

        private void submitPostprocessing() {
            PostprocessorProducer.this.mExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean isLast;
                    CloseableReference closeableImageRef;
                    PostprocessorConsumer postprocessorConsumer = PostprocessorConsumer.this;
                    synchronized (postprocessorConsumer) {
                        closeableImageRef = PostprocessorConsumer.this.mSourceImageRef;
                        isLast = PostprocessorConsumer.this.mIsLast;
                        PostprocessorConsumer.this.mSourceImageRef = null;
                        PostprocessorConsumer.this.mIsDirty = false;
                    }
                    if (CloseableReference.isValid((CloseableReference)closeableImageRef)) {
                        try {
                            PostprocessorConsumer.this.doPostprocessing((CloseableReference<CloseableImage>)closeableImageRef, isLast);
                        }
                        finally {
                            CloseableReference.closeSafely((CloseableReference)closeableImageRef);
                        }
                    }
                    PostprocessorConsumer.this.clearRunningAndStartIfDirty();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearRunningAndStartIfDirty() {
            boolean shouldExecuteAgain;
            PostprocessorConsumer postprocessorConsumer = this;
            synchronized (postprocessorConsumer) {
                this.mIsPostProcessingRunning = false;
                shouldExecuteAgain = this.setRunningIfDirtyAndNotRunning();
            }
            if (shouldExecuteAgain) {
                this.submitPostprocessing();
            }
        }

        private synchronized boolean setRunningIfDirtyAndNotRunning() {
            if (!this.mIsClosed && this.mIsDirty && !this.mIsPostProcessingRunning && CloseableReference.isValid(this.mSourceImageRef)) {
                this.mIsPostProcessingRunning = true;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPostprocessing(CloseableReference<CloseableImage> sourceImageRef, boolean isLast) {
            Preconditions.checkArgument((boolean)CloseableReference.isValid(sourceImageRef));
            if (!this.shouldPostprocess((CloseableImage)sourceImageRef.get())) {
                this.maybeNotifyOnNewResult(sourceImageRef, isLast);
                return;
            }
            this.mListener.onProducerStart(this.mRequestId, PostprocessorProducer.NAME);
            CloseableReference<CloseableImage> destImageRef = null;
            try {
                try {
                    destImageRef = this.postprocessInternal((CloseableImage)sourceImageRef.get());
                }
                catch (Exception e) {
                    this.mListener.onProducerFinishWithFailure(this.mRequestId, PostprocessorProducer.NAME, e, this.getExtraMap(this.mListener, this.mRequestId, this.mPostprocessor));
                    this.maybeNotifyOnFailure(e);
                    CloseableReference.closeSafely(destImageRef);
                    return;
                }
                this.mListener.onProducerFinishWithSuccess(this.mRequestId, PostprocessorProducer.NAME, this.getExtraMap(this.mListener, this.mRequestId, this.mPostprocessor));
                this.maybeNotifyOnNewResult(destImageRef, isLast);
            }
            finally {
                CloseableReference.closeSafely(destImageRef);
            }
        }

        private Map<String, String> getExtraMap(ProducerListener listener, String requestId, Postprocessor postprocessor) {
            if (!listener.requiresExtraMap(requestId)) {
                return null;
            }
            return ImmutableMap.of((Object)PostprocessorProducer.POSTPROCESSOR, (Object)postprocessor.getName());
        }

        private boolean shouldPostprocess(CloseableImage sourceImage) {
            return sourceImage instanceof CloseableStaticBitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CloseableReference<CloseableImage> postprocessInternal(CloseableImage sourceImage) {
            Bitmap sourceBitmap = ((CloseableStaticBitmap)sourceImage).getUnderlyingBitmap();
            CloseableReference<Bitmap> bitmapRef = this.mPostprocessor.process(sourceBitmap, PostprocessorProducer.this.mBitmapFactory);
            try {
                CloseableReference closeableReference = CloseableReference.of((Closeable)new CloseableStaticBitmap(bitmapRef, sourceImage.getQualityInfo()));
                return closeableReference;
            }
            finally {
                CloseableReference.closeSafely(bitmapRef);
            }
        }

        private void maybeNotifyOnNewResult(CloseableReference<CloseableImage> newRef, boolean isLast) {
            if (!isLast && !this.isClosed() || isLast && this.close()) {
                this.getConsumer().onNewResult(newRef, isLast);
            }
        }

        private void maybeNotifyOnFailure(Throwable throwable) {
            if (this.close()) {
                this.getConsumer().onFailure(throwable);
            }
        }

        private void maybeNotifyOnCancellation() {
            if (this.close()) {
                this.getConsumer().onCancellation();
            }
        }

        private synchronized boolean isClosed() {
            return this.mIsClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean close() {
            CloseableReference<CloseableImage> oldSourceImageRef;
            PostprocessorConsumer postprocessorConsumer = this;
            synchronized (postprocessorConsumer) {
                if (this.mIsClosed) {
                    return false;
                }
                oldSourceImageRef = this.mSourceImageRef;
                this.mSourceImageRef = null;
                this.mIsClosed = true;
            }
            CloseableReference.closeSafely(oldSourceImageRef);
            return true;
        }
    }
}

