/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Sets;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContext;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.MultiplexProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class MultiplexProducer<K, T>
implements Producer<CloseableReference<T>> {
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<K, Multiplexer> mMultiplexers;
    private final Producer<CloseableReference<T>> mNextProducer;

    protected MultiplexProducer(Producer<CloseableReference<T>> nextProducer) {
        this.mNextProducer = nextProducer;
        this.mMultiplexers = new HashMap<K, Multiplexer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<CloseableReference<T>> consumer, ProducerContext context) {
        boolean createdNewMultiplexer;
        Multiplexer multiplexer;
        K key = this.getKey(context);
        do {
            createdNewMultiplexer = false;
            MultiplexProducer multiplexProducer = this;
            synchronized (multiplexProducer) {
                multiplexer = this.getExistingMultiplexer(key);
                if (multiplexer == null) {
                    multiplexer = this.createAndPutNewMultiplexer(key);
                    createdNewMultiplexer = true;
                }
            }
        } while (!multiplexer.addNewConsumer(consumer, context));
        if (createdNewMultiplexer) {
            multiplexer.startNextProducerIfHasAttachedConsumers();
        }
    }

    private synchronized Multiplexer getExistingMultiplexer(K key) {
        return this.mMultiplexers.get(key);
    }

    private synchronized Multiplexer createAndPutNewMultiplexer(K key) {
        Multiplexer multiplexer = new Multiplexer(key);
        this.mMultiplexers.put(key, multiplexer);
        return multiplexer;
    }

    private synchronized void removeMultiplexer(K key, Multiplexer multiplexer) {
        if (this.mMultiplexers.get(key) == multiplexer) {
            this.mMultiplexers.remove(key);
        }
    }

    protected abstract K getKey(ProducerContext var1);

    @VisibleForTesting
    class Multiplexer {
        private final K mKey;
        private final CopyOnWriteArraySet<Pair<Consumer<CloseableReference<T>>, ProducerContext>> mConsumerContextPairs = Sets.newCopyOnWriteArraySet();
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private CloseableReference<T> mLastIntermediateResult;
        @GuardedBy(value="Multiplexer.this")
        private float mLastProgress;
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private BaseProducerContext mMultiplexProducerContext;
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private com.facebook.imagepipeline.producers.MultiplexProducer$Multiplexer.ForwardingConsumer mForwardingConsumer;

        public Multiplexer(K key) {
            this.mKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addNewConsumer(Consumer<CloseableReference<T>> consumer, ProducerContext producerContext) {
            float lastProgress;
            CloseableReference lastIntermediateResult;
            List<ProducerContextCallbacks> intermediateResultsCallbacks;
            List<ProducerContextCallbacks> priorityCallbacks;
            List<ProducerContextCallbacks> prefetchCallbacks;
            Pair consumerContextPair = Pair.create(consumer, (Object)producerContext);
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (MultiplexProducer.this.getExistingMultiplexer(this.mKey) != this) {
                    return false;
                }
                this.mConsumerContextPairs.add(consumerContextPair);
                prefetchCallbacks = this.updateIsPrefetch();
                priorityCallbacks = this.updatePriority();
                intermediateResultsCallbacks = this.updateIsIntermediateResultExpected();
                lastIntermediateResult = this.mLastIntermediateResult;
                lastProgress = this.mLastProgress;
            }
            BaseProducerContext.callOnIsPrefetchChanged(prefetchCallbacks);
            BaseProducerContext.callOnPriorityChanged(priorityCallbacks);
            BaseProducerContext.callOnIsIntermediateResultExpectedChanged(intermediateResultsCallbacks);
            multiplexer = consumerContextPair;
            synchronized (multiplexer) {
                Multiplexer multiplexer2 = this;
                synchronized (multiplexer2) {
                    if (lastIntermediateResult != this.mLastIntermediateResult) {
                        lastIntermediateResult = null;
                    } else if (lastIntermediateResult != null) {
                        lastIntermediateResult = lastIntermediateResult.clone();
                    }
                }
                if (lastIntermediateResult != null) {
                    if (lastProgress > 0.0f) {
                        consumer.onProgressUpdate(lastProgress);
                    }
                    consumer.onNewResult(lastIntermediateResult, false);
                    lastIntermediateResult.close();
                }
            }
            this.addCallbacks(consumerContextPair, producerContext);
            return true;
        }

        private void addCallbacks(final Pair<Consumer<CloseableReference<T>>, ProducerContext> consumerContextPair, ProducerContext producerContext) {
            producerContext.addCallbacks(new BaseProducerContextCallbacks(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellationRequested() {
                    boolean pairWasRemoved;
                    BaseProducerContext contextToCancel = null;
                    List isPrefetchCallbacks = null;
                    List priorityCallbacks = null;
                    List isIntermediateResultExpectedCallbacks = null;
                    Multiplexer multiplexer = Multiplexer.this;
                    synchronized (multiplexer) {
                        pairWasRemoved = Multiplexer.this.mConsumerContextPairs.remove(consumerContextPair);
                        if (pairWasRemoved) {
                            if (Multiplexer.this.mConsumerContextPairs.isEmpty()) {
                                contextToCancel = Multiplexer.this.mMultiplexProducerContext;
                            } else {
                                isPrefetchCallbacks = Multiplexer.this.updateIsPrefetch();
                                priorityCallbacks = Multiplexer.this.updatePriority();
                                isIntermediateResultExpectedCallbacks = Multiplexer.this.updateIsIntermediateResultExpected();
                            }
                        }
                    }
                    BaseProducerContext.callOnIsPrefetchChanged(isPrefetchCallbacks);
                    BaseProducerContext.callOnPriorityChanged(priorityCallbacks);
                    BaseProducerContext.callOnIsIntermediateResultExpectedChanged(isIntermediateResultExpectedCallbacks);
                    if (contextToCancel != null) {
                        contextToCancel.cancel();
                    }
                    if (pairWasRemoved) {
                        ((Consumer)consumerContextPair.first).onCancellation();
                    }
                }

                @Override
                public void onIsPrefetchChanged() {
                    BaseProducerContext.callOnIsPrefetchChanged(Multiplexer.this.updateIsPrefetch());
                }

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    BaseProducerContext.callOnIsIntermediateResultExpectedChanged(Multiplexer.this.updateIsIntermediateResultExpected());
                }

                @Override
                public void onPriorityChanged() {
                    BaseProducerContext.callOnPriorityChanged(Multiplexer.this.updatePriority());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startNextProducerIfHasAttachedConsumers() {
            com.facebook.imagepipeline.producers.MultiplexProducer$Multiplexer.ForwardingConsumer forwardingConsumer;
            BaseProducerContext multiplexProducerContext;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                Preconditions.checkArgument((this.mMultiplexProducerContext == null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.mForwardingConsumer == null ? 1 : 0) != 0);
                if (this.mConsumerContextPairs.isEmpty()) {
                    MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                    return;
                }
                ProducerContext producerContext = (ProducerContext)this.mConsumerContextPairs.iterator().next().second;
                this.mMultiplexProducerContext = new BaseProducerContext(producerContext.getImageRequest(), producerContext.getId(), producerContext.getListener(), producerContext.getCallerContext(), producerContext.getLowestPermittedRequestLevel(), this.computeIsPrefetch(), this.computeIsIntermediateResultExpected(), this.computePriority());
                this.mForwardingConsumer = new ForwardingConsumer();
                multiplexProducerContext = this.mMultiplexProducerContext;
                forwardingConsumer = this.mForwardingConsumer;
            }
            MultiplexProducer.this.mNextProducer.produceResults(forwardingConsumer, multiplexProducerContext);
        }

        @Nullable
        private synchronized List<ProducerContextCallbacks> updateIsPrefetch() {
            if (this.mMultiplexProducerContext == null) {
                return null;
            }
            return this.mMultiplexProducerContext.setIsPrefetchNoCallbacks(this.computeIsPrefetch());
        }

        private synchronized boolean computeIsPrefetch() {
            for (Pair pair : this.mConsumerContextPairs) {
                if (((ProducerContext)pair.second).isPrefetch()) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private synchronized List<ProducerContextCallbacks> updateIsIntermediateResultExpected() {
            if (this.mMultiplexProducerContext == null) {
                return null;
            }
            return this.mMultiplexProducerContext.setIsIntermediateResultExpectedNoCallbacks(this.computeIsIntermediateResultExpected());
        }

        private synchronized boolean computeIsIntermediateResultExpected() {
            for (Pair pair : this.mConsumerContextPairs) {
                if (!((ProducerContext)pair.second).isIntermediateResultExpected()) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private synchronized List<ProducerContextCallbacks> updatePriority() {
            if (this.mMultiplexProducerContext == null) {
                return null;
            }
            return this.mMultiplexProducerContext.setPriorityNoCallbacks(this.computePriority());
        }

        private synchronized Priority computePriority() {
            Priority priority = Priority.LOW;
            for (Pair pair : this.mConsumerContextPairs) {
                priority = Priority.getHigherPriority(priority, ((ProducerContext)pair.second).getPriority());
            }
            return priority;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(ForwardingConsumer consumer, Throwable t) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != consumer) {
                    return;
                }
                iterator = this.mConsumerContextPairs.iterator();
                this.mConsumerContextPairs.clear();
                MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                CloseableReference.closeSafely(this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((Consumer)pair.first).onFailure(t);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNextResult(ForwardingConsumer consumer, CloseableReference closeableReference, boolean isFinal) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != consumer) {
                    return;
                }
                CloseableReference.closeSafely(this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
                iterator = this.mConsumerContextPairs.iterator();
                if (!isFinal) {
                    this.mLastIntermediateResult = closeableReference.clone();
                } else {
                    this.mConsumerContextPairs.clear();
                    MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                }
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((Consumer)pair.first).onNewResult(closeableReference, isFinal);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancelled(ForwardingConsumer forwardingConsumer) {
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != forwardingConsumer) {
                    return;
                }
                this.mForwardingConsumer = null;
                this.mMultiplexProducerContext = null;
                CloseableReference.closeSafely(this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
            }
            this.startNextProducerIfHasAttachedConsumers();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProgressUpdate(ForwardingConsumer forwardingConsumer, float progress) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != forwardingConsumer) {
                    return;
                }
                this.mLastProgress = progress;
                iterator = this.mConsumerContextPairs.iterator();
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((Consumer)pair.first).onProgressUpdate(progress);
                }
            }
        }

        private class ForwardingConsumer
        extends BaseConsumer<CloseableReference<T>> {
            private ForwardingConsumer() {
            }

            @Override
            protected void onNewResultImpl(CloseableReference<T> newResult, boolean isLast) {
                Multiplexer.this.onNextResult(this, newResult, isLast);
            }

            @Override
            protected void onFailureImpl(Throwable t) {
                Multiplexer.this.onFailure(this, t);
            }

            @Override
            protected void onCancellationImpl() {
                Multiplexer.this.onCancelled(this);
            }

            @Override
            protected void onProgressUpdateImpl(float progress) {
                Multiplexer.this.onProgressUpdate(this, progress);
            }
        }
    }
}

