/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;

public class FetchState {
    private final Consumer<CloseableReference<PooledByteBuffer>> mConsumer;
    private final ProducerContext mContext;
    private long mLastIntermediateResultTimeMs;

    public FetchState(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext context) {
        this.mConsumer = consumer;
        this.mContext = context;
        this.mLastIntermediateResultTimeMs = 0L;
    }

    public Consumer<CloseableReference<PooledByteBuffer>> getConsumer() {
        return this.mConsumer;
    }

    public ProducerContext getContext() {
        return this.mContext;
    }

    public String getId() {
        return this.mContext.getId();
    }

    public ProducerListener getListener() {
        return this.mContext.getListener();
    }

    public Uri getUri() {
        return this.mContext.getImageRequest().getSourceUri();
    }

    public long getLastIntermediateResultTimeMs() {
        return this.mLastIntermediateResultTimeMs;
    }

    public void setLastIntermediateResultTimeMs(long lastIntermediateResultTimeMs) {
        this.mLastIntermediateResultTimeMs = lastIntermediateResultTimeMs;
    }
}

