/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;

public class EncodedMemoryCacheProducer
implements Producer<CloseableReference<PooledByteBuffer>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "EncodedMemoryCacheProducer";
    @VisibleForTesting
    static final String VALUE_FOUND = "cached_value_found";
    private final MemoryCache<CacheKey, PooledByteBuffer> mMemoryCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public EncodedMemoryCacheProducer(MemoryCache<CacheKey, PooledByteBuffer> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext producerContext) {
        String requestId = producerContext.getId();
        ProducerListener listener = producerContext.getListener();
        listener.onProducerStart(requestId, PRODUCER_NAME);
        ImageRequest imageRequest = producerContext.getImageRequest();
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest);
        CloseableReference<PooledByteBuffer> cachedReference = this.mMemoryCache.get(cacheKey);
        if (cachedReference != null) {
            listener.onProducerFinishWithSuccess(requestId, PRODUCER_NAME, listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"true") : null);
            consumer.onProgressUpdate(1.0f);
            consumer.onNewResult(cachedReference, true);
            cachedReference.close();
            return;
        }
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE.getValue()) {
            listener.onProducerFinishWithSuccess(requestId, PRODUCER_NAME, listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"false") : null);
            consumer.onNewResult(null, true);
            return;
        }
        DelegatingConsumer<CloseableReference<PooledByteBuffer>, CloseableReference<PooledByteBuffer>> consumerOfNextProducer = new DelegatingConsumer<CloseableReference<PooledByteBuffer>, CloseableReference<PooledByteBuffer>>(consumer){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
                if (!isLast || newResult == null) {
                    this.getConsumer().onNewResult(newResult, isLast);
                    return;
                }
                CloseableReference<PooledByteBuffer> cachedResult = EncodedMemoryCacheProducer.this.mMemoryCache.cache(cacheKey, newResult);
                try {
                    this.getConsumer().onProgressUpdate(1.0f);
                    this.getConsumer().onNewResult(cachedResult != null ? cachedResult : newResult, true);
                }
                finally {
                    CloseableReference.closeSafely(cachedResult);
                }
            }
        };
        listener.onProducerFinishWithSuccess(requestId, PRODUCER_NAME, listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"false") : null);
        this.mNextProducer.produceResults((Consumer<CloseableReference<PooledByteBuffer>>)consumerOfNextProducer, producerContext);
    }
}

