/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@TargetApi(value=21)
public class BitmapPool
extends BasePool<Bitmap> {
    public BitmapPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker poolStatsTracker) {
        super(memoryTrimmableRegistry, poolParams, poolStatsTracker);
        this.initialize();
    }

    @Override
    protected Bitmap alloc(int size) {
        return Bitmap.createBitmap((int)1, (int)size, (Bitmap.Config)Bitmaps.BITMAP_CONFIG);
    }

    @Override
    protected void free(Bitmap value) {
        Preconditions.checkNotNull((Object)value);
        value.recycle();
    }

    @Override
    protected int getBucketedSize(int requestSize) {
        return requestSize;
    }

    @Override
    protected int getBucketedSizeForValue(Bitmap value) {
        Preconditions.checkNotNull((Object)value);
        int allocationByteCount = value.getAllocationByteCount();
        return allocationByteCount / 4;
    }

    @Override
    protected int getSizeInBytes(int bucketedSize) {
        return 4 * bucketedSize;
    }

    @Override
    protected boolean isReusable(Bitmap value) {
        Preconditions.checkNotNull((Object)value);
        return !value.isRecycled() && value.isMutable() && Bitmaps.BITMAP_CONFIG.equals((Object)value.getConfig());
    }
}

