/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class StagingArea {
    private static final Class<?> TAG = StagingArea.class;
    @GuardedBy(value="this")
    private Map<CacheKey, CloseableReference<PooledByteBuffer>> mMap = new HashMap<CacheKey, CloseableReference<PooledByteBuffer>>();

    private StagingArea() {
    }

    public static StagingArea getInstance() {
        return new StagingArea();
    }

    public synchronized void put(CacheKey key, CloseableReference<PooledByteBuffer> bufferRef) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)CloseableReference.isValid(bufferRef));
        CloseableReference<PooledByteBuffer> oldEntry = this.mMap.put(key, (CloseableReference<PooledByteBuffer>)bufferRef.clone());
        if (oldEntry != null) {
            oldEntry.close();
        }
        this.logStats();
    }

    public synchronized boolean remove(CacheKey key, CloseableReference<PooledByteBuffer> bufferRef) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(bufferRef);
        Preconditions.checkArgument((boolean)CloseableReference.isValid(bufferRef));
        CloseableReference<PooledByteBuffer> oldValue = this.mMap.get(key);
        if (oldValue == null || oldValue.get() != bufferRef.get()) {
            return false;
        }
        this.mMap.remove(key);
        oldValue.close();
        this.logStats();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableReference<PooledByteBuffer> get(CacheKey key) {
        Preconditions.checkNotNull((Object)key);
        CloseableReference storedRef = this.mMap.get(key);
        if (storedRef != null) {
            CloseableReference closeableReference = storedRef;
            synchronized (closeableReference) {
                if (!CloseableReference.isValid(storedRef)) {
                    this.mMap.remove(key);
                    FLog.w(TAG, (String)"Found closed reference %d for key %s (%d)", (Object[])new Object[]{System.identityHashCode(storedRef), key.toString(), System.identityHashCode(key)});
                    return null;
                }
                storedRef = storedRef.clone();
            }
        }
        return storedRef;
    }

    private synchronized void logStats() {
        FLog.v(TAG, (String)"Count = %d", (Object)this.mMap.size());
    }
}

