/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.QualityInfo;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CloseableStaticBitmap
extends CloseableBitmap {
    @GuardedBy(value="this")
    private CloseableReference<Bitmap> mBitmapReference;
    private volatile Bitmap mBitmap;
    private final QualityInfo mQualityInfo;

    public CloseableStaticBitmap(Bitmap bitmap, ResourceReleaser<Bitmap> resourceReleaser, QualityInfo qualityInfo) {
        this.mBitmap = (Bitmap)Preconditions.checkNotNull((Object)bitmap);
        this.mBitmapReference = CloseableReference.of((Object)this.mBitmap, (ResourceReleaser)((ResourceReleaser)Preconditions.checkNotNull(resourceReleaser)));
        this.mQualityInfo = qualityInfo;
    }

    public CloseableStaticBitmap(CloseableReference<Bitmap> bitmapReference, QualityInfo qualityInfo) {
        this.mBitmapReference = (CloseableReference)Preconditions.checkNotNull((Object)bitmapReference.cloneOrNull());
        this.mBitmap = (Bitmap)this.mBitmapReference.get();
        this.mQualityInfo = qualityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CloseableReference<Bitmap> reference;
        CloseableStaticBitmap closeableStaticBitmap = this;
        synchronized (closeableStaticBitmap) {
            if (this.mBitmapReference == null) {
                return;
            }
            reference = this.mBitmapReference;
            this.mBitmapReference = null;
            this.mBitmap = null;
        }
        reference.close();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mBitmapReference == null;
    }

    @Override
    public Bitmap getUnderlyingBitmap() {
        return this.mBitmap;
    }

    @Override
    public int getSizeInBytes() {
        Bitmap bitmap = this.mBitmap;
        return bitmap == null ? 0 : bitmap.getHeight() * bitmap.getRowBytes();
    }

    @Override
    public int getWidth() {
        Bitmap bitmap = this.mBitmap;
        return bitmap == null ? 0 : bitmap.getWidth();
    }

    @Override
    public int getHeight() {
        Bitmap bitmap = this.mBitmap;
        return bitmap == null ? 0 : bitmap.getHeight();
    }

    @Override
    public QualityInfo getQualityInfo() {
        return this.mQualityInfo;
    }
}

