/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Rect;
import android.util.Pair;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imageutils.JfifUtil;

public class AddImageTransformMetaDataProducer
implements Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public AddImageTransformMetaDataProducer(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new AddImageTransformMetaDataConsumer(consumer), context);
    }

    private class AddImageTransformMetaDataConsumer
    extends DelegatingConsumer<CloseableReference<PooledByteBuffer>, Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
        private final ImageTransformMetaData.Builder mMetaDataBuilder;

        private AddImageTransformMetaDataConsumer(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer) {
            super(consumer);
            this.mMetaDataBuilder = new ImageTransformMetaData.Builder();
        }

        @Override
        protected void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(new PooledByteBufferInputStream((PooledByteBuffer)newResult.get()));
            this.mMetaDataBuilder.reset();
            this.mMetaDataBuilder.setImageFormat(imageFormat);
            if (imageFormat == ImageFormat.JPEG && isLast) {
                this.mMetaDataBuilder.setRotationAngle(this.getRotationAngle(newResult));
                Rect dimensions = JfifUtil.getDimensions(new PooledByteBufferInputStream((PooledByteBuffer)newResult.get()));
                if (dimensions != null) {
                    this.mMetaDataBuilder.setWidth(dimensions.width());
                    this.mMetaDataBuilder.setHeight(dimensions.height());
                }
            }
            this.getConsumer().onNewResult(Pair.create(newResult, (Object)this.mMetaDataBuilder.build()), isLast);
        }

        private int getRotationAngle(CloseableReference<PooledByteBuffer> inputRef) {
            return JfifUtil.getAutoRotateAngleFromOrientation(JfifUtil.getOrientation(new PooledByteBufferInputStream((PooledByteBuffer)inputRef.get())));
        }
    }
}

