/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.NativeMemoryChunk;
import com.facebook.imagepipeline.memory.NativeMemoryChunkPool;
import com.facebook.imagepipeline.memory.NativePooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NativePooledByteBufferOutputStream
extends PooledByteBufferOutputStream {
    private final NativeMemoryChunkPool mPool;
    private CloseableReference<NativeMemoryChunk> mBufRef;
    private int mCount;

    public NativePooledByteBufferOutputStream(NativeMemoryChunkPool pool) {
        this(pool, pool.getMinBufferSize());
    }

    public NativePooledByteBufferOutputStream(NativeMemoryChunkPool pool, int initialCapacity) {
        Preconditions.checkArgument((initialCapacity > 0 ? 1 : 0) != 0);
        this.mPool = (NativeMemoryChunkPool)Preconditions.checkNotNull((Object)pool);
        this.mCount = 0;
        this.mBufRef = CloseableReference.of(this.mPool.get(initialCapacity), (ResourceReleaser)this.mPool);
    }

    @Override
    public NativePooledByteBuffer toByteBuffer() {
        this.ensureValid();
        return new NativePooledByteBuffer(this.mBufRef, this.mCount);
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] buf = new byte[]{(byte)oneByte};
        this.write(buf);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (offset < 0 || count < 0 || offset + count > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        this.ensureValid();
        this.realloc(this.mCount + count);
        ((NativeMemoryChunk)this.mBufRef.get()).write(this.mCount, buffer, offset, count);
        this.mCount += count;
    }

    @Override
    public void close() {
        CloseableReference.closeSafely(this.mBufRef);
        this.mBufRef = null;
        this.mCount = -1;
        super.close();
    }

    @VisibleForTesting
    void realloc(int newLength) {
        this.ensureValid();
        if (newLength <= ((NativeMemoryChunk)this.mBufRef.get()).getSize()) {
            return;
        }
        NativeMemoryChunk newbuf = (NativeMemoryChunk)this.mPool.get(newLength);
        ((NativeMemoryChunk)this.mBufRef.get()).copy(0, newbuf, 0, this.mCount);
        this.mBufRef.close();
        this.mBufRef = CloseableReference.of((Object)newbuf, (ResourceReleaser)this.mPool);
    }

    private void ensureValid() {
        if (!CloseableReference.isValid(this.mBufRef)) {
            throw new InvalidStreamException();
        }
    }

    public static class InvalidStreamException
    extends RuntimeException {
        public InvalidStreamException() {
            super("OutputStream no longer valid");
        }
    }
}

