/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.StreamUtil;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteArrayBufferedInputStream;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressiveJpegParser {
    private static final int READ_FIRST_JPEG_BYTE = 0;
    private static final int READ_SECOND_JPEG_BYTE = 1;
    private static final int READ_MARKER_FIRST_BYTE_OR_ENTROPY_DATA = 2;
    private static final int READ_MARKER_SECOND_BYTE = 3;
    private static final int READ_SIZE_FIRST_BYTE = 4;
    private static final int READ_SIZE_SECOND_BYTE = 5;
    private static final int NOT_A_JPEG = 6;
    private static final int BUFFER_SIZE = 16384;
    private int mParserState;
    private int mLastByteRead;
    private int mBytesParsed;
    private int mNextFullScanNumber;
    private int mBestScanNumber;
    private int mBestScanEndOffset;
    private final ByteArrayPool mByteArrayPool;

    public ProgressiveJpegParser(ByteArrayPool byteArrayPool) {
        this.mByteArrayPool = (ByteArrayPool)Preconditions.checkNotNull((Object)byteArrayPool);
        this.mBytesParsed = 0;
        this.mLastByteRead = 0;
        this.mNextFullScanNumber = 0;
        this.mBestScanEndOffset = 0;
        this.mBestScanNumber = 0;
        this.mParserState = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseMoreData(CloseableReference<PooledByteBuffer> dataBufferRef) {
        if (this.mParserState == 6) {
            return false;
        }
        PooledByteBuffer dataBuffer = (PooledByteBuffer)dataBufferRef.get();
        int dataBufferSize = dataBuffer.size();
        if (dataBufferSize <= this.mBytesParsed) {
            return false;
        }
        PooledByteArrayBufferedInputStream bufferedDataStream = new PooledByteArrayBufferedInputStream(new PooledByteBufferInputStream(dataBuffer), (byte[])this.mByteArrayPool.get(16384), this.mByteArrayPool);
        try {
            StreamUtil.skip((InputStream)bufferedDataStream, (long)this.mBytesParsed);
            boolean bl = this.doParseMoreData(bufferedDataStream);
            return bl;
        }
        catch (IOException ioe) {
            Throwables.propagate((Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            Closeables.closeQuietly((InputStream)bufferedDataStream);
        }
    }

    private boolean doParseMoreData(InputStream inputStream) {
        int oldBestScanNumber = this.mBestScanNumber;
        try {
            int nextByte;
            while (this.mParserState != 6 && (nextByte = inputStream.read()) != -1) {
                ++this.mBytesParsed;
                switch (this.mParserState) {
                    case 0: {
                        if (nextByte == 255) {
                            this.mParserState = 1;
                            break;
                        }
                        this.mParserState = 6;
                        break;
                    }
                    case 1: {
                        if (nextByte == 216) {
                            this.mParserState = 2;
                            break;
                        }
                        this.mParserState = 6;
                        break;
                    }
                    case 2: {
                        if (nextByte != 255) break;
                        this.mParserState = 3;
                        break;
                    }
                    case 3: {
                        if (nextByte == 255) {
                            this.mParserState = 3;
                            break;
                        }
                        if (nextByte == 0) {
                            this.mParserState = 2;
                            break;
                        }
                        if (nextByte == 218 || nextByte == 217) {
                            this.newScanOrImageEndFound(this.mBytesParsed - 2);
                        }
                        if (ProgressiveJpegParser.doesMarkerStartSegment(nextByte)) {
                            this.mParserState = 4;
                            break;
                        }
                        this.mParserState = 2;
                        break;
                    }
                    case 4: {
                        this.mParserState = 5;
                        break;
                    }
                    case 5: {
                        int size = (this.mLastByteRead << 8) + nextByte;
                        int bytesToSkip = size - 2;
                        StreamUtil.skip((InputStream)inputStream, (long)bytesToSkip);
                        this.mBytesParsed += bytesToSkip;
                        this.mParserState = 2;
                        break;
                    }
                    default: {
                        Preconditions.checkState((boolean)false);
                    }
                }
                this.mLastByteRead = nextByte;
            }
        }
        catch (IOException ioe) {
            Throwables.propagate((Throwable)ioe);
        }
        return this.mParserState != 6 && this.mBestScanNumber != oldBestScanNumber;
    }

    private static boolean doesMarkerStartSegment(int markerSecondByte) {
        if (markerSecondByte == 1) {
            return false;
        }
        if (markerSecondByte >= 208 && markerSecondByte <= 215) {
            return false;
        }
        return markerSecondByte != 217 && markerSecondByte != 216;
    }

    private void newScanOrImageEndFound(int offset) {
        if (this.mNextFullScanNumber > 0) {
            this.mBestScanEndOffset = offset;
        }
        this.mBestScanNumber = this.mNextFullScanNumber++;
    }

    public boolean isJpeg() {
        return this.mBytesParsed > 1 && this.mParserState != 6;
    }

    public int getBestScanEndOffset() {
        return this.mBestScanEndOffset;
    }

    public int getBestScanNumber() {
        return this.mBestScanNumber;
    }
}

