/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.common.executors.SerialDelegatingExecutor;
import com.facebook.imagepipeline.core.ExecutorSupplier;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultExecutorSupplier
implements ExecutorSupplier {
    private static final int NUM_IO_BOUND_THREADS = 2;
    private static final int NUM_CPU_BOUND_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int KEEP_ALIVE_SECONDS = 60;
    private final Executor mIoBoundExecutor = Executors.newFixedThreadPool(2);
    private final Executor mCpuBoundExecutor = new ThreadPoolExecutor(1, NUM_CPU_BOUND_THREADS, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Executor mDecodeExecutor = new SerialDelegatingExecutor(this.mCpuBoundExecutor);

    @Override
    public Executor forLocalStorageRead() {
        return this.mIoBoundExecutor;
    }

    @Override
    public Executor forLocalStorageWrite() {
        return this.mIoBoundExecutor;
    }

    @Override
    public Executor forDecode() {
        return this.mDecodeExecutor;
    }

    @Override
    public Executor forTransform() {
        return this.mCpuBoundExecutor;
    }

    @Override
    public Executor forBackground() {
        return this.mCpuBoundExecutor;
    }
}

