/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.nativecode.WebpTranscoder;
import com.facebook.imagepipeline.producers.ImageTransformProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.concurrent.Executor;

public class WebpTranscodeProducer
extends ImageTransformProducer<CloseableReference<PooledByteBuffer>, Void> {
    private static final String PRODUCER_NAME = "WebpTranscodeProducer";
    private static final int DEFAULT_JPEG_QUALITY = 80;

    public WebpTranscodeProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        super(executor, pooledByteBufferFactory, nextProducer);
    }

    @Override
    protected TriState shouldTransform(CloseableReference<PooledByteBuffer> imageRef, ImageRequest imageRequest, boolean isLast) {
        PooledByteBufferInputStream imageInputStream = new PooledByteBufferInputStream((PooledByteBuffer)imageRef.get());
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(imageInputStream);
        switch (imageFormat) {
            case WEBP_SIMPLE: 
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                return TriState.valueOf((!WebpTranscoder.isWebpNativelySupported(imageFormat) ? 1 : 0) != 0);
            }
            case UNKNOWN: {
                return isLast ? TriState.NO : TriState.UNSET;
            }
        }
        return TriState.NO;
    }

    @Override
    protected void transform(CloseableReference<PooledByteBuffer> imageRef, PooledByteBufferOutputStream outputStream, ImageRequest imageRequest, Void unused) throws Exception {
        PooledByteBufferInputStream imageInputStream = new PooledByteBufferInputStream((PooledByteBuffer)imageRef.get());
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(imageInputStream);
        switch (imageFormat) {
            case WEBP_SIMPLE: 
            case WEBP_EXTENDED: {
                WebpTranscoder.transcodeWebpToJpeg(imageInputStream, outputStream, 80);
                break;
            }
            case WEBP_LOSSLESS: 
            case WEBP_EXTENDED_WITH_ALPHA: {
                WebpTranscoder.transcodeWebpToPng(imageInputStream, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image format");
            }
        }
    }

    @Override
    protected CloseableReference<PooledByteBuffer> getImageCopy(CloseableReference<PooledByteBuffer> originalResult) {
        return originalResult.clone();
    }

    @Override
    protected Void getExtraInformation(CloseableReference<PooledByteBuffer> originalResult) {
        return null;
    }

    @Override
    protected CloseableReference<PooledByteBuffer> createReturnValue(PooledByteBuffer transformedBytes, Void unused) {
        return CloseableReference.of((Closeable)transformedBytes);
    }

    @Override
    protected void closeReturnValue(CloseableReference<PooledByteBuffer> returnValue) {
        CloseableReference.closeSafely(returnValue);
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    @Override
    protected boolean shouldAllowCancellation() {
        return false;
    }
}

