/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import android.os.SystemClock;
import com.facebook.common.executors.UiThreadExecutorService;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.decoder.ProgressiveJpegParser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class DecodeProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "DecodeProducer";
    private static final String QUEUE_TIME_KEY = "queueTime";
    private static final String HAS_GOOD_QUALITY_KEY = "hasGoodQuality";
    private static final String IS_FINAL_KEY = "isFinal";
    private final ByteArrayPool mByteArrayPool;
    private final Executor mExecutor;
    private final ImageDecoder mImageDecoder;
    private final ProgressiveJpegConfig mProgressiveJpegConfig;
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public DecodeProducer(ByteArrayPool byteArrayPool, Executor executor, ImageDecoder imageDecoder, ProgressiveJpegConfig progressiveJpegConfig, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mByteArrayPool = (ByteArrayPool)Preconditions.checkNotNull((Object)byteArrayPool);
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mImageDecoder = (ImageDecoder)Preconditions.checkNotNull((Object)imageDecoder);
        this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext context) {
        ProgressiveDecoder progressiveDecoder;
        ImageRequest imageRequest = context.getImageRequest();
        if (!UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri())) {
            progressiveDecoder = new LocalImagesProgressiveDecoder(consumer, context);
        } else {
            ProgressiveJpegParser jpegParser = new ProgressiveJpegParser(this.mByteArrayPool);
            progressiveDecoder = new NetworkImagesProgressiveDecoder(consumer, context, jpegParser, this.mProgressiveJpegConfig);
        }
        this.mNextProducer.produceResults(progressiveDecoder, context);
    }

    class NetworkImagesProgressiveDecoder
    extends ProgressiveDecoder {
        private final ProgressiveJpegParser mProgressiveJpegParser;
        private final ProgressiveJpegConfig mProgressiveJpegConfig;
        private int mLastScheduledScanNumber;

        public NetworkImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, ProgressiveJpegParser progressiveJpegParser, ProgressiveJpegConfig progressiveJpegConfig) {
            super(consumer, producerContext);
            this.mProgressiveJpegParser = (ProgressiveJpegParser)Preconditions.checkNotNull((Object)progressiveJpegParser);
            this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
            this.mLastScheduledScanNumber = 0;
        }

        @Override
        protected synchronized boolean updateDecodeJob(CloseableReference<PooledByteBuffer> imageBytesRef, boolean isLast) {
            boolean ret = super.updateDecodeJob(imageBytesRef, isLast);
            if (!isLast && CloseableReference.isValid(imageBytesRef)) {
                if (!this.mProgressiveJpegParser.parseMoreData(imageBytesRef)) {
                    return false;
                }
                int scanNum = this.mProgressiveJpegParser.getBestScanNumber();
                if (scanNum <= this.mLastScheduledScanNumber || scanNum < this.mProgressiveJpegConfig.getNextScanNumberToDecode(this.mLastScheduledScanNumber)) {
                    return false;
                }
                this.mLastScheduledScanNumber = scanNum;
            }
            return ret;
        }

        @Override
        @Nullable
        protected ImageFormat getImageFormat(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return this.mProgressiveJpegParser.isJpeg() ? ImageFormat.JPEG : ImageFormat.UNKNOWN;
        }

        @Override
        protected int getIntermediateImageEndOffset(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return this.mProgressiveJpegParser.getBestScanEndOffset();
        }

        @Override
        protected QualityInfo getQualityInfo(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return this.mProgressiveJpegConfig.getQualityInfo(this.mProgressiveJpegParser.getBestScanNumber());
        }
    }

    class LocalImagesProgressiveDecoder
    extends ProgressiveDecoder {
        public LocalImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
            super(consumer, producerContext);
        }

        @Override
        @Nullable
        protected ImageFormat getImageFormat(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return null;
        }

        @Override
        protected int getIntermediateImageEndOffset(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return ((PooledByteBuffer)imageBytesRef.get()).size();
        }

        @Override
        protected QualityInfo getQualityInfo(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return ImmutableQualityInfo.of(0, false, false);
        }
    }

    @VisibleForTesting
    abstract class ProgressiveDecoder
    extends DelegatingConsumer<CloseableReference<PooledByteBuffer>, CloseableReference<CloseableImage>> {
        protected final ProducerContext mProducerContext;
        private final ProducerListener mProducerListener;
        private final ImageDecodeOptions mImageDecodeOptions;
        private final Runnable mSubmitDecodeRunnable;
        @GuardedBy(value="this")
        private boolean mIsFinished;
        @GuardedBy(value="this")
        @VisibleForTesting
        CloseableReference<PooledByteBuffer> mImageBytesRef;
        @GuardedBy(value="this")
        private boolean mIsLast;
        @GuardedBy(value="this")
        private boolean mIsDecodeSubmitted;
        @GuardedBy(value="this")
        private long mLastDecodeTime;

        public ProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mProducerListener = producerContext.getListener();
            this.mImageDecodeOptions = producerContext.getImageRequest().getImageDecodeOptions();
            this.mIsFinished = false;
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (ProgressiveDecoder.this.mProducerContext.isIntermediateResultExpected()) {
                        ProgressiveDecoder.this.scheduleDecodeJob(((ProgressiveDecoder)ProgressiveDecoder.this).mImageDecodeOptions.minDecodeIntervalMs);
                    }
                }
            });
            this.mSubmitDecodeRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressiveDecoder.this.submitDecode();
                }
            };
        }

        @Override
        public void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            if (!this.updateDecodeJob(newResult, isLast)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.scheduleDecodeJob(isLast ? 0 : this.mImageDecodeOptions.minDecodeIntervalMs);
            }
        }

        @Override
        public void onFailureImpl(Throwable t) {
            this.handleError(t);
        }

        @Override
        public void onCancellationImpl() {
            this.handleCancellation();
        }

        protected synchronized boolean updateDecodeJob(CloseableReference<PooledByteBuffer> imageBytesRef, boolean isLast) {
            if (!isLast && !CloseableReference.isValid(imageBytesRef)) {
                return false;
            }
            CloseableReference.closeSafely(this.mImageBytesRef);
            this.mImageBytesRef = CloseableReference.cloneOrNull(imageBytesRef);
            this.mIsLast = isLast;
            return true;
        }

        private synchronized void scheduleDecodeJob(int minDecodeIntervalMs) {
            if (!this.mIsDecodeSubmitted) {
                this.mIsDecodeSubmitted = true;
                long now = SystemClock.uptimeMillis();
                long when = Math.max(this.mLastDecodeTime + (long)minDecodeIntervalMs, now);
                if (when > now) {
                    UiThreadExecutorService.getInstance().schedule(this.mSubmitDecodeRunnable, when - now, TimeUnit.MILLISECONDS);
                } else {
                    this.mSubmitDecodeRunnable.run();
                }
            }
        }

        protected void submitDecode() {
            final long submitTime = SystemClock.uptimeMillis();
            DecodeProducer.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    long queueTime = SystemClock.uptimeMillis() - submitTime;
                    ProgressiveDecoder.this.doDecode(queueTime);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDecode(long queueTime) {
            boolean isLast;
            CloseableReference<PooledByteBuffer> bytesRef;
            ProgressiveDecoder progressiveDecoder = this;
            synchronized (progressiveDecoder) {
                bytesRef = this.mImageBytesRef;
                this.mImageBytesRef = null;
                isLast = this.mIsLast;
                this.mIsDecodeSubmitted = false;
                this.mLastDecodeTime = SystemClock.uptimeMillis();
            }
            try {
                CloseableImage decodedImage;
                if (this.isFinished() || !CloseableReference.isValid(bytesRef)) {
                    return;
                }
                ImageFormat format = isLast ? ImageFormat.UNKNOWN : this.getImageFormat(bytesRef);
                int length = isLast ? ((PooledByteBuffer)bytesRef.get()).size() : this.getIntermediateImageEndOffset(bytesRef);
                QualityInfo quality = isLast ? ImmutableQualityInfo.FULL_QUALITY : this.getQualityInfo(bytesRef);
                this.mProducerListener.onProducerStart(this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME);
                try {
                    decodedImage = DecodeProducer.this.mImageDecoder.decodeImage(bytesRef, format, length, quality, this.mImageDecodeOptions);
                }
                catch (Exception e) {
                    Map<String, String> extraMap = this.getExtraMap(queueTime, quality, isLast);
                    this.mProducerListener.onProducerFinishWithFailure(this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME, e, extraMap);
                    this.handleError(e);
                    CloseableReference.closeSafely(bytesRef);
                    return;
                }
                Map<String, String> extraMap = this.getExtraMap(queueTime, quality, isLast);
                this.mProducerListener.onProducerFinishWithSuccess(this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME, extraMap);
                this.handleResult(decodedImage, isLast);
            }
            finally {
                CloseableReference.closeSafely(bytesRef);
            }
        }

        private Map<String, String> getExtraMap(long queueTime, QualityInfo qualityInfo, boolean isFinal) {
            if (!this.mProducerListener.requiresExtraMap(this.mProducerContext.getId())) {
                return null;
            }
            return ImmutableMap.of((Object)DecodeProducer.QUEUE_TIME_KEY, (Object)String.valueOf(queueTime), (Object)DecodeProducer.HAS_GOOD_QUALITY_KEY, (Object)String.valueOf(qualityInfo.isOfGoodEnoughQuality()), (Object)DecodeProducer.IS_FINAL_KEY, (Object)String.valueOf(isFinal));
        }

        private synchronized boolean isFinished() {
            return this.mIsFinished;
        }

        private synchronized void maybeFinish(boolean finish) {
            if (this.mIsFinished) {
                return;
            }
            this.mIsFinished = finish;
            if (finish) {
                CloseableReference.closeSafely(this.mImageBytesRef);
                this.mImageBytesRef = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResult(CloseableImage decodedImage, boolean isFinal) {
            CloseableReference decodedImageRef = CloseableReference.of((Closeable)decodedImage);
            try {
                this.maybeFinish(isFinal);
                this.getConsumer().onNewResult(decodedImageRef, isFinal);
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)decodedImageRef);
            }
        }

        private void handleError(Throwable t) {
            this.maybeFinish(true);
            this.getConsumer().onFailure(t);
        }

        private void handleCancellation() {
            this.maybeFinish(true);
            this.getConsumer().onCancellation();
        }

        @Nullable
        protected abstract ImageFormat getImageFormat(CloseableReference<PooledByteBuffer> var1);

        protected abstract int getIntermediateImageEndOffset(CloseableReference<PooledByteBuffer> var1);

        protected abstract QualityInfo getQualityInfo(CloseableReference<PooledByteBuffer> var1);
    }
}

