/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;

@DoNotStrip
public class Bitmaps {
    public static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    public static final int BYTES_PER_PIXEL = 4;

    public static void pinBitmap(Bitmap bitmap) {
        Preconditions.checkNotNull((Object)bitmap);
        Bitmaps.nativePinBitmap(bitmap);
    }

    public static void copyBitmap(Bitmap dest, Bitmap src) {
        Preconditions.checkArgument((src.getConfig() == Bitmap.Config.ARGB_8888 ? 1 : 0) != 0);
        Preconditions.checkArgument((dest.getConfig() == Bitmap.Config.ARGB_8888 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)dest.isMutable());
        Preconditions.checkArgument((dest.getWidth() == src.getWidth() ? 1 : 0) != 0);
        Preconditions.checkArgument((dest.getHeight() == src.getHeight() ? 1 : 0) != 0);
        Bitmaps.nativeCopyBitmap(dest, dest.getRowBytes(), src, src.getRowBytes(), dest.getHeight());
    }

    @TargetApi(value=19)
    public static void reconfigureBitmap(Bitmap bitmap, int width, int height) {
        Preconditions.checkArgument((bitmap.getAllocationByteCount() >= width * height * 4 ? 1 : 0) != 0);
        bitmap.reconfigure(width, height, BITMAP_CONFIG);
    }

    @DoNotStrip
    private static native void nativePinBitmap(Bitmap var0);

    @DoNotStrip
    private static native void nativeCopyBitmap(Bitmap var0, int var1, Bitmap var2, int var3, int var4);

    static {
        ImagePipelineNativeLoader.load();
    }
}

