/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import java.io.Closeable;

public class CloseableImageCopier {
    private final PlatformBitmapFactory mPlatformBitmapFactory;

    public CloseableImageCopier(PlatformBitmapFactory platformBitmapFactory) {
        this.mPlatformBitmapFactory = platformBitmapFactory;
    }

    public CloseableReference<CloseableImage> copyCloseableImage(CloseableReference<CloseableImage> closeableImageRef) {
        Preconditions.checkArgument((boolean)this.isCloseableImageCopyable(closeableImageRef));
        return this.copyCloseableStaticBitmap(closeableImageRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableReference<CloseableImage> copyCloseableStaticBitmap(CloseableReference<CloseableImage> closeableStaticBitmapRef) {
        Bitmap sourceBitmap = ((CloseableStaticBitmap)closeableStaticBitmapRef.get()).getUnderlyingBitmap();
        try (CloseableReference<Bitmap> bitmapRef = this.mPlatformBitmapFactory.createBitmap(sourceBitmap.getWidth(), sourceBitmap.getHeight());){
            Bitmap destinationBitmap = (Bitmap)bitmapRef.get();
            Preconditions.checkState((!destinationBitmap.isRecycled() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)destinationBitmap.isMutable());
            Bitmaps.copyBitmap(destinationBitmap, sourceBitmap);
            CloseableReference closeableReference = CloseableReference.of((Closeable)new CloseableStaticBitmap(bitmapRef, ImmutableQualityInfo.FULL_QUALITY));
            return closeableReference;
        }
    }

    public boolean isCloseableImageCopyable(CloseableReference<CloseableImage> closeableImageRef) {
        return closeableImageRef != null && closeableImageRef.get() instanceof CloseableStaticBitmap;
    }
}

