/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.NativeMemoryChunk;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NativePooledByteBuffer
implements PooledByteBuffer {
    private final int mSize;
    @GuardedBy(value="this")
    @VisibleForTesting
    CloseableReference<NativeMemoryChunk> mBufRef;

    public NativePooledByteBuffer(CloseableReference<NativeMemoryChunk> bufRef, int size) {
        Preconditions.checkNotNull(bufRef);
        Preconditions.checkArgument((size >= 0 && size <= ((NativeMemoryChunk)bufRef.get()).getSize() ? 1 : 0) != 0);
        this.mBufRef = bufRef.clone();
        this.mSize = size;
    }

    public synchronized int size() {
        this.ensureValid();
        return this.mSize;
    }

    public synchronized byte read(int offset) {
        this.ensureValid();
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset < this.mSize ? 1 : 0) != 0);
        return ((NativeMemoryChunk)this.mBufRef.get()).read(offset);
    }

    public synchronized void read(int offset, byte[] buffer, int bufferOffset, int length) {
        this.ensureValid();
        Preconditions.checkArgument((offset + length <= this.mSize ? 1 : 0) != 0);
        ((NativeMemoryChunk)this.mBufRef.get()).read(offset, buffer, bufferOffset, length);
    }

    public synchronized long getNativePtr() {
        this.ensureValid();
        return ((NativeMemoryChunk)this.mBufRef.get()).getNativePtr();
    }

    public synchronized boolean isClosed() {
        return !CloseableReference.isValid(this.mBufRef);
    }

    public synchronized void close() {
        CloseableReference.closeSafely(this.mBufRef);
        this.mBufRef = null;
    }

    synchronized void ensureValid() {
        if (this.isClosed()) {
            throw new PooledByteBuffer.ClosedException();
        }
    }
}

