/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imagepipeline.core.ImagePipelineConfig;

public class ImagePipelineExperiments {
    private final int mForceSmallCacheThresholdBytes;
    private final boolean mWebpSupportEnabled;
    private boolean mDecodeFileDescriptorEnabled;
    private final int mThrottlingMaxSimultaneousRequests;

    private ImagePipelineExperiments(Builder builder, ImagePipelineConfig.Builder configBuilder) {
        this.mForceSmallCacheThresholdBytes = builder.mForceSmallCacheThresholdBytes;
        this.mWebpSupportEnabled = builder.mWebpSupportEnabled && WebpSupportStatus.sWebpLibraryPresent;
        this.mDecodeFileDescriptorEnabled = configBuilder.isDownsampleEnabled() && builder.mDecodeFileDescriptorEnabled;
        this.mThrottlingMaxSimultaneousRequests = builder.mThrottlingMaxSimultaneousRequests;
    }

    public boolean isDecodeFileDescriptorEnabled() {
        return this.mDecodeFileDescriptorEnabled;
    }

    public int getForceSmallCacheThresholdBytes() {
        return this.mForceSmallCacheThresholdBytes;
    }

    public boolean isWebpSupportEnabled() {
        return this.mWebpSupportEnabled;
    }

    public int getThrottlingMaxSimultaneousRequests() {
        return this.mThrottlingMaxSimultaneousRequests;
    }

    public static Builder newBuilder(ImagePipelineConfig.Builder configBuilder) {
        return new Builder(configBuilder);
    }

    public static class Builder {
        private static final int DEFAULT_MAX_SIMULTANEOUS_FILE_FETCH_AND_RESIZE = 5;
        private final ImagePipelineConfig.Builder mConfigBuilder;
        private int mForceSmallCacheThresholdBytes = 0;
        private boolean mWebpSupportEnabled = false;
        private boolean mDecodeFileDescriptorEnabled = false;
        private int mThrottlingMaxSimultaneousRequests = 5;

        public Builder(ImagePipelineConfig.Builder configBuilder) {
            this.mConfigBuilder = configBuilder;
        }

        public ImagePipelineConfig.Builder setDecodeFileDescriptorEnabled(boolean decodeFileDescriptorEnabled) {
            this.mDecodeFileDescriptorEnabled = decodeFileDescriptorEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setForceSmallCacheThresholdBytes(int forceSmallCacheThresholdBytes) {
            this.mForceSmallCacheThresholdBytes = forceSmallCacheThresholdBytes;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpSupportEnabled(boolean webpSupportEnabled) {
            this.mWebpSupportEnabled = webpSupportEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setThrottlingMaxSimultaneousRequests(int throttlingMaxSimultaneousRequests) {
            this.mThrottlingMaxSimultaneousRequests = throttlingMaxSimultaneousRequests;
            return this.mConfigBuilder;
        }

        public ImagePipelineExperiments build() {
            return new ImagePipelineExperiments(this, this.mConfigBuilder);
        }
    }
}

