/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ThumbnailProducer;
import com.facebook.imagepipeline.producers.ThumbnailSizeChecker;

public class ThumbnailBranchProducer
implements Producer<EncodedImage> {
    private final ThumbnailProducer<EncodedImage>[] mThumbnailProducers;

    public ThumbnailBranchProducer(ThumbnailProducer<EncodedImage> ... thumbnailProducers) {
        this.mThumbnailProducers = (ThumbnailProducer[])Preconditions.checkNotNull(thumbnailProducers);
        Preconditions.checkElementIndex((int)0, (int)this.mThumbnailProducers.length);
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        if (context.getImageRequest().getResizeOptions() == null) {
            consumer.onNewResult(null, true);
        } else {
            boolean requested = this.produceResultsFromThumbnailProducer(0, consumer, context);
            if (!requested) {
                consumer.onNewResult(null, true);
            }
        }
    }

    private boolean produceResultsFromThumbnailProducer(int startIndex, Consumer<EncodedImage> consumer, ProducerContext context) {
        int producerIndex = this.findFirstProducerForSize(startIndex, context.getImageRequest().getResizeOptions());
        if (producerIndex == -1) {
            return false;
        }
        this.mThumbnailProducers[producerIndex].produceResults(new ThumbnailConsumer(consumer, context, producerIndex), context);
        return true;
    }

    private int findFirstProducerForSize(int startIndex, ResizeOptions resizeOptions) {
        for (int i = startIndex; i < this.mThumbnailProducers.length; ++i) {
            if (!this.mThumbnailProducers[i].canProvideImageForSize(resizeOptions)) continue;
            return i;
        }
        return -1;
    }

    private class ThumbnailConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private final int mProducerIndex;
        private final ResizeOptions mResizeOptions;

        public ThumbnailConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext, int producerIndex) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mProducerIndex = producerIndex;
            this.mResizeOptions = this.mProducerContext.getImageRequest().getResizeOptions();
        }

        @Override
        protected void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (newResult != null && (!isLast || ThumbnailSizeChecker.isImageBigEnough(newResult, this.mResizeOptions))) {
                this.getConsumer().onNewResult(newResult, isLast);
            } else if (isLast) {
                EncodedImage.closeSafely((EncodedImage)newResult);
                boolean fallback = ThumbnailBranchProducer.this.produceResultsFromThumbnailProducer(this.mProducerIndex + 1, this.getConsumer(), this.mProducerContext);
                if (!fallback) {
                    this.getConsumer().onNewResult(null, true);
                }
            }
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            boolean fallback = ThumbnailBranchProducer.this.produceResultsFromThumbnailProducer(this.mProducerIndex + 1, this.getConsumer(), this.mProducerContext);
            if (!fallback) {
                this.getConsumer().onFailure(t);
            }
        }
    }
}

