/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.listener;

import android.os.SystemClock;
import android.util.Pair;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class RequestLoggingListener
implements RequestListener {
    private static final String TAG = "RequestLoggingListener";
    @GuardedBy(value="this")
    private final Map<Pair<String, String>, Long> mProducerStartTimeMap = new HashMap<Pair<String, String>, Long>();
    @GuardedBy(value="this")
    private final Map<String, Long> mRequestStartTimeMap = new HashMap<String, Long>();

    @Override
    public synchronized void onRequestStart(ImageRequest request, Object callerContextObject, String requestId, boolean isPrefetch) {
        if (FLog.isLoggable((int)2)) {
            FLog.v((String)TAG, (String)"time %d: onRequestSubmit: {requestId: %s, callerContext: %s, isPrefetch: %b}", (Object)RequestLoggingListener.getTime(), (Object)requestId, (Object)callerContextObject, (Object)isPrefetch);
            this.mRequestStartTimeMap.put(requestId, RequestLoggingListener.getTime());
        }
    }

    @Override
    public synchronized void onProducerStart(String requestId, String producerName) {
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            long startTime = RequestLoggingListener.getTime();
            this.mProducerStartTimeMap.put((Pair<String, String>)mapKey, startTime);
            FLog.v((String)TAG, (String)"time %d: onProducerStart: {requestId: %s, producer: %s}", (Object)startTime, (Object)requestId, (Object)producerName);
        }
    }

    @Override
    public synchronized void onProducerFinishWithSuccess(String requestId, String producerName, @Nullable Map<String, String> extraMap) {
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.mProducerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.getTime();
            FLog.v((String)TAG, (String)"time %d: onProducerFinishWithSuccess: {requestId: %s, producer: %s, elapsedTime: %d ms, extraMap: %s}", (Object[])new Object[]{currentTime, requestId, producerName, RequestLoggingListener.getElapsedTime(startTime, currentTime), extraMap});
        }
    }

    @Override
    public synchronized void onProducerFinishWithFailure(String requestId, String producerName, Throwable throwable, @Nullable Map<String, String> extraMap) {
        if (FLog.isLoggable((int)5)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.mProducerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.getTime();
            FLog.w((String)TAG, (String)"time %d: onProducerFinishWithFailure: {requestId: %s, stage: %s, elapsedTime: %d ms, extraMap: %s, throwable: %s}", (Object[])new Object[]{currentTime, requestId, producerName, RequestLoggingListener.getElapsedTime(startTime, currentTime), extraMap, throwable.toString()});
        }
    }

    @Override
    public synchronized void onProducerFinishWithCancellation(String requestId, String producerName, @Nullable Map<String, String> extraMap) {
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.mProducerStartTimeMap.remove(mapKey);
            long currentTime = RequestLoggingListener.getTime();
            FLog.v((String)TAG, (String)"time %d: onProducerFinishWithCancellation: {requestId: %s, stage: %s, elapsedTime: %d ms, extraMap: %s}", (Object[])new Object[]{currentTime, requestId, producerName, RequestLoggingListener.getElapsedTime(startTime, currentTime), extraMap});
        }
    }

    @Override
    public synchronized void onProducerEvent(String requestId, String producerName, String producerEventName) {
        if (FLog.isLoggable((int)2)) {
            Pair mapKey = Pair.create((Object)requestId, (Object)producerName);
            Long startTime = this.mProducerStartTimeMap.get(mapKey);
            long currentTime = RequestLoggingListener.getTime();
            FLog.v((String)TAG, (String)"time %d: onProducerEvent: {requestId: %s, stage: %s, eventName: %s; elapsedTime: %d ms}", (Object[])new Object[]{RequestLoggingListener.getTime(), requestId, producerName, producerEventName, RequestLoggingListener.getElapsedTime(startTime, currentTime)});
        }
    }

    @Override
    public synchronized void onRequestSuccess(ImageRequest request, String requestId, boolean isPrefetch) {
        if (FLog.isLoggable((int)2)) {
            Long startTime = this.mRequestStartTimeMap.remove(requestId);
            long currentTime = RequestLoggingListener.getTime();
            FLog.v((String)TAG, (String)"time %d: onRequestSuccess: {requestId: %s, elapsedTime: %d ms}", (Object)currentTime, (Object)requestId, (Object)RequestLoggingListener.getElapsedTime(startTime, currentTime));
        }
    }

    @Override
    public synchronized void onRequestFailure(ImageRequest request, String requestId, Throwable throwable, boolean isPrefetch) {
        if (FLog.isLoggable((int)5)) {
            Long startTime = this.mRequestStartTimeMap.remove(requestId);
            long currentTime = RequestLoggingListener.getTime();
            FLog.w((String)TAG, (String)"time %d: onRequestFailure: {requestId: %s, elapsedTime: %d ms, throwable: %s}", (Object[])new Object[]{currentTime, requestId, RequestLoggingListener.getElapsedTime(startTime, currentTime), throwable.toString()});
        }
    }

    @Override
    public synchronized void onRequestCancellation(String requestId) {
        if (FLog.isLoggable((int)2)) {
            Long startTime = this.mRequestStartTimeMap.remove(requestId);
            long currentTime = RequestLoggingListener.getTime();
            FLog.v((String)TAG, (String)"time %d: onRequestCancellation: {requestId: %s, elapsedTime: %d ms}", (Object)currentTime, (Object)requestId, (Object)RequestLoggingListener.getElapsedTime(startTime, currentTime));
        }
    }

    @Override
    public boolean requiresExtraMap(String id) {
        return FLog.isLoggable((int)2);
    }

    private static long getElapsedTime(@Nullable Long startTime, long endTime) {
        if (startTime != null) {
            return endTime - startTime;
        }
        return -1L;
    }

    private static long getTime() {
        return SystemClock.uptimeMillis();
    }
}

