/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import java.util.ArrayList;
import java.util.concurrent.Executor;

public class ThreadHandoffProducerQueue {
    private boolean mQueueing = false;
    private final ArrayList<Runnable> mRunnableList;
    private final Executor mExecutor;

    public ThreadHandoffProducerQueue(Executor executor) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mRunnableList = new ArrayList();
    }

    public synchronized void addToQueueOrExecute(Runnable runnable) {
        if (this.mQueueing) {
            this.mRunnableList.add(runnable);
        } else {
            this.mExecutor.execute(runnable);
        }
    }

    public synchronized void startQueueing() {
        this.mQueueing = true;
    }

    public synchronized void stopQueuing() {
        this.mQueueing = false;
        this.execInQueue();
    }

    private void execInQueue() {
        for (Runnable runnable : this.mRunnableList) {
            this.mExecutor.execute(runnable);
        }
        this.mRunnableList.clear();
    }

    public void remove(Runnable runnable) {
        this.mRunnableList.remove(runnable);
    }

    public synchronized boolean isQueueing() {
        return this.mQueueing;
    }
}

