/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.net.Uri;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import java.io.File;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageRequest {
    private final ImageType mImageType;
    private final Uri mSourceUri;
    private File mSourceFile;
    private final boolean mProgressiveRenderingEnabled;
    private final boolean mLocalThumbnailPreviewsEnabled;
    private final ImageDecodeOptions mImageDecodeOptions;
    @Nullable
    ResizeOptions mResizeOptions = null;
    private final boolean mAutoRotateEnabled;
    private final RequestLevel mLowestPermittedRequestLevel;
    private final Postprocessor mPostprocessor;

    public static ImageRequest fromUri(@Nullable Uri uri) {
        return uri == null ? null : ImageRequestBuilder.newBuilderWithSource(uri).build();
    }

    public static ImageRequest fromUri(@Nullable String uriString) {
        return uriString == null || uriString.length() == 0 ? null : ImageRequest.fromUri(Uri.parse((String)uriString));
    }

    protected ImageRequest(ImageRequestBuilder builder) {
        this.mImageType = builder.getImageType();
        this.mSourceUri = builder.getSourceUri();
        this.mProgressiveRenderingEnabled = builder.isProgressiveRenderingEnabled();
        this.mLocalThumbnailPreviewsEnabled = builder.isLocalThumbnailPreviewsEnabled();
        this.mImageDecodeOptions = builder.getImageDecodeOptions();
        this.mResizeOptions = builder.getResizeOptions();
        this.mAutoRotateEnabled = builder.isAutoRotateEnabled();
        this.mLowestPermittedRequestLevel = builder.getLowestPermittedRequestLevel();
        this.mPostprocessor = builder.getPostprocessor();
    }

    public ImageType getImageType() {
        return this.mImageType;
    }

    public Uri getSourceUri() {
        return this.mSourceUri;
    }

    public int getPreferredWidth() {
        return this.mResizeOptions != null ? this.mResizeOptions.width : -1;
    }

    public int getPreferredHeight() {
        return this.mResizeOptions != null ? this.mResizeOptions.height : -1;
    }

    @Nullable
    public ResizeOptions getResizeOptions() {
        return this.mResizeOptions;
    }

    public ImageDecodeOptions getImageDecodeOptions() {
        return this.mImageDecodeOptions;
    }

    public boolean getAutoRotateEnabled() {
        return this.mAutoRotateEnabled;
    }

    public boolean getProgressiveRenderingEnabled() {
        return this.mProgressiveRenderingEnabled;
    }

    public boolean getLocalThumbnailPreviewsEnabled() {
        return this.mLocalThumbnailPreviewsEnabled;
    }

    public RequestLevel getLowestPermittedRequestLevel() {
        return this.mLowestPermittedRequestLevel;
    }

    public synchronized File getSourceFile() {
        if (this.mSourceFile == null) {
            this.mSourceFile = new File(this.mSourceUri.getPath());
        }
        return this.mSourceFile;
    }

    @Nullable
    public Postprocessor getPostprocessor() {
        return this.mPostprocessor;
    }

    public static enum RequestLevel {
        FULL_FETCH(1),
        DISK_CACHE(2),
        ENCODED_MEMORY_CACHE(3),
        BITMAP_MEMORY_CACHE(4);

        private int mValue;

        private RequestLevel(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum ImageType {
        SMALL,
        DEFAULT;

    }
}

