/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Lists;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SettableProducerContext
implements ProducerContext {
    private final ImageRequest mImageRequest;
    private final String mId;
    private final ProducerListener mProducerListener;
    private final Object mCallerContext;
    @GuardedBy(value="this")
    private final List<ProducerContextCallbacks> mCallbacks;
    @GuardedBy(value="this")
    private boolean mIsCancelled;
    @GuardedBy(value="this")
    private boolean mIsPrefetch;
    @GuardedBy(value="this")
    private Priority mPriority;
    @GuardedBy(value="this")
    private boolean mIsIntermediateResultExpected;

    public SettableProducerContext(ImageRequest imageRequest, String id, ProducerListener producerListener, Object callerContext, boolean isPrefetch, boolean isIntermediateResultExpected, Priority priority) {
        this.mImageRequest = (ImageRequest)Preconditions.checkNotNull((Object)imageRequest);
        this.mId = (String)Preconditions.checkNotNull((Object)id);
        this.mProducerListener = (ProducerListener)Preconditions.checkNotNull((Object)producerListener);
        this.mCallerContext = callerContext;
        this.mIsPrefetch = isPrefetch;
        this.mIsIntermediateResultExpected = isIntermediateResultExpected;
        this.mPriority = priority;
        this.mIsCancelled = false;
        this.mCallbacks = Lists.newArrayList();
    }

    @Override
    public ImageRequest getImageRequest() {
        return this.mImageRequest;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public ProducerListener getListener() {
        return this.mProducerListener;
    }

    @Override
    public Object getCallerContext() {
        return this.mCallerContext;
    }

    @Override
    public synchronized boolean isPrefetch() {
        return this.mIsPrefetch;
    }

    @Override
    public synchronized Priority getPriority() {
        return this.mPriority;
    }

    @Override
    public synchronized boolean isIntermediateResultExpected() {
        return this.mIsIntermediateResultExpected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallbacks(ProducerContextCallbacks callbacks) {
        boolean cancelImmediately = false;
        SettableProducerContext settableProducerContext = this;
        synchronized (settableProducerContext) {
            this.mCallbacks.add(callbacks);
            if (this.mIsCancelled) {
                cancelImmediately = true;
            }
        }
        if (cancelImmediately) {
            callbacks.onCancellationRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ArrayList callbacks = null;
        SettableProducerContext settableProducerContext = this;
        synchronized (settableProducerContext) {
            if (!this.mIsCancelled) {
                this.mIsCancelled = true;
                callbacks = Lists.newArrayList(this.mCallbacks);
            }
        }
        if (callbacks != null) {
            for (ProducerContextCallbacks callback : callbacks) {
                callback.onCancellationRequested();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsPrefetch(boolean isPrefetch) {
        ArrayList callbacks = null;
        SettableProducerContext settableProducerContext = this;
        synchronized (settableProducerContext) {
            if (this.mIsPrefetch != isPrefetch) {
                this.mIsPrefetch = isPrefetch;
                callbacks = Lists.newArrayList(this.mCallbacks);
            }
        }
        if (callbacks != null) {
            for (ProducerContextCallbacks callback : callbacks) {
                callback.onIsPrefetchChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsIntermediateResultExpected(boolean isIntermediateResultExpected) {
        ArrayList callbacks = null;
        SettableProducerContext settableProducerContext = this;
        synchronized (settableProducerContext) {
            if (this.mIsIntermediateResultExpected != isIntermediateResultExpected) {
                this.mIsIntermediateResultExpected = isIntermediateResultExpected;
                callbacks = Lists.newArrayList(this.mCallbacks);
            }
        }
        if (callbacks != null) {
            for (ProducerContextCallbacks callback : callbacks) {
                callback.onIsIntermediateResultExpectedChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(Priority priority) {
        ArrayList callbacks = null;
        SettableProducerContext settableProducerContext = this;
        synchronized (settableProducerContext) {
            if (this.mPriority != priority) {
                this.mPriority = priority;
                callbacks = Lists.newArrayList(this.mCallbacks);
            }
        }
        if (callbacks != null) {
            for (ProducerContextCallbacks callback : callbacks) {
                callback.onPriorityChanged();
            }
        }
    }

    @VisibleForTesting
    synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }
}

