/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.nativecode.JpegTranscoder;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.ImageTransformProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.concurrent.Executor;

public class ResizeAndRotateProducer
extends ImageTransformProducer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>, ImageTransformMetaData> {
    private static final String PRODUCER_NAME = "ResizeAndRotateProducer";
    @VisibleForTesting
    static final int DEFAULT_JPEG_QUALITY = 85;
    @VisibleForTesting
    static final int MAX_JPEG_SCALE_NUMERATOR = 8;

    public ResizeAndRotateProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> nextProducer) {
        super(executor, pooledByteBufferFactory, nextProducer);
    }

    @Override
    protected TriState shouldTransform(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> input, ImageRequest imageRequest, boolean isLast) {
        ImageTransformMetaData metaData = (ImageTransformMetaData)input.second;
        switch (metaData.getImageFormat()) {
            case JPEG: {
                return isLast ? TriState.valueOf((ResizeAndRotateProducer.getRotationAngle(imageRequest, metaData) != 0 || ResizeAndRotateProducer.getScaleNumerator(imageRequest, metaData) != 8 ? 1 : 0) != 0) : TriState.UNSET;
            }
            case UNKNOWN: {
                return isLast ? TriState.NO : TriState.UNSET;
            }
        }
        return TriState.NO;
    }

    @Override
    protected void transform(CloseableReference<PooledByteBuffer> imageRef, PooledByteBufferOutputStream outputStream, ImageRequest imageRequest, ImageTransformMetaData metaData) throws Exception {
        JpegTranscoder.transcodeJpeg(((PooledByteBuffer)imageRef.get()).getStream(), outputStream, ResizeAndRotateProducer.getRotationAngle(imageRequest, metaData), ResizeAndRotateProducer.getScaleNumerator(imageRequest, metaData), 85);
    }

    @Override
    protected CloseableReference<PooledByteBuffer> getImageCopy(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> originalResult) {
        return ((CloseableReference)originalResult.first).clone();
    }

    @Override
    protected ImageTransformMetaData getExtraInformation(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> originalResult) {
        return (ImageTransformMetaData)originalResult.second;
    }

    @Override
    protected Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> createReturnValue(PooledByteBuffer transformedBytes, ImageTransformMetaData metaData) {
        return Pair.create((Object)CloseableReference.of((Closeable)transformedBytes), (Object)metaData);
    }

    @Override
    protected void closeReturnValue(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> returnValue) {
        CloseableReference.closeSafely((CloseableReference)((CloseableReference)returnValue.first));
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    @Override
    protected boolean shouldAllowCancellation() {
        return true;
    }

    private static int getScaleNumerator(ImageRequest imageRequest, ImageTransformMetaData metaData) {
        int heightAfterRotation;
        float heightRatio;
        ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        if (resizeOptions == null) {
            return 8;
        }
        int rotationAngle = ResizeAndRotateProducer.getRotationAngle(imageRequest, metaData);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? metaData.getHeight() : metaData.getWidth();
        float widthRatio = (float)resizeOptions.width / (float)widthAfterRotation;
        int numerator = (int)Math.ceil(Math.max(widthRatio, heightRatio = (float)resizeOptions.height / (float)(heightAfterRotation = swapDimensions ? metaData.getWidth() : metaData.getHeight())) * 8.0f);
        if (numerator > 8) {
            return 8;
        }
        if (numerator < 1) {
            return 1;
        }
        return numerator;
    }

    private static int getRotationAngle(ImageRequest imageRequest, ImageTransformMetaData metaData) {
        if (!imageRequest.getAutoRotateEnabled()) {
            return 0;
        }
        int rotationAngle = metaData.getRotationAngle();
        Preconditions.checkArgument((rotationAngle == 0 || rotationAngle == 90 || rotationAngle == 180 || rotationAngle == 270 ? 1 : 0) != 0);
        return rotationAngle;
    }
}

