/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.decoder.CloseableImageCopier;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.imagepipeline.request.RepeatedPostprocessor;
import com.facebook.imagepipeline.request.RepeatedPostprocessorRunner;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

public class PostprocessorProducer
implements Producer<CloseableReference<CloseableImage>> {
    @VisibleForTesting
    static final String NAME = "PostprocessorProducer";
    @VisibleForTesting
    static final String BITMAP_COPIED_EVENT = "bitmap_copied";
    @VisibleForTesting
    static final String POSTPROCESSOR = "Postprocessor";
    private final Producer<CloseableReference<CloseableImage>> mNextProducer;
    private final CloseableImageCopier mCloseableImageCopier;
    private final Executor mExecutor;

    public PostprocessorProducer(Producer<CloseableReference<CloseableImage>> nextProducer, CloseableImageCopier closeableImageCopier, Executor executor) {
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
        this.mCloseableImageCopier = (CloseableImageCopier)Preconditions.checkNotNull((Object)closeableImageCopier);
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext context) {
        ProducerListener listener = context.getListener();
        Postprocessor postprocessor = context.getImageRequest().getPostprocessor();
        AbstractPostprocessorConsumer postprocessorConsumer = postprocessor instanceof RepeatedPostprocessor ? new RepeatedPostprocessorConsumer(consumer, listener, context.getId(), (RepeatedPostprocessor)postprocessor, context) : new SingleUsePostprocessorConsumer(consumer, listener, context.getId(), postprocessor);
        this.mNextProducer.produceResults(postprocessorConsumer, context);
    }

    private class RepeatedPostprocessorConsumer
    extends AbstractPostprocessorConsumer
    implements RepeatedPostprocessorRunner {
        @GuardedBy(value="this")
        private CloseableReference<CloseableImage> mOriginalImageRef;
        @GuardedBy(value="this")
        private boolean mIsDirty;
        @GuardedBy(value="this")
        private boolean mIsPostProcessingRunning;

        private RepeatedPostprocessorConsumer(Consumer<CloseableReference<CloseableImage>> consumer, ProducerListener listener, String requestId, RepeatedPostprocessor repeatedPostprocessor, ProducerContext context) {
            super(consumer, listener, requestId, repeatedPostprocessor);
            repeatedPostprocessor.setCallback(this);
            context.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onCancellationRequested() {
                    RepeatedPostprocessorConsumer.this.closeOriginalImage();
                    RepeatedPostprocessorConsumer.this.mConsumer.onCancellation();
                }
            });
            this.mIsDirty = false;
            this.mIsPostProcessingRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, boolean isLast) {
            if (!isLast) {
                return;
            }
            if (!PostprocessorProducer.this.mCloseableImageCopier.isCloseableImageCopyable(newResult)) {
                this.mConsumer.onNewResult(newResult, true);
                return;
            }
            RepeatedPostprocessorConsumer repeatedPostprocessorConsumer = this;
            synchronized (repeatedPostprocessorConsumer) {
                this.mOriginalImageRef = newResult.clone();
            }
            this.maybeExecuteCopyAndPostprocessBitmap();
        }

        @Override
        public synchronized void update() {
            this.maybeExecuteCopyAndPostprocessBitmap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeExecuteCopyAndPostprocessBitmap() {
            boolean shouldExecutePostProcessing = false;
            RepeatedPostprocessorConsumer repeatedPostprocessorConsumer = this;
            synchronized (repeatedPostprocessorConsumer) {
                this.mIsDirty = true;
                if (!this.mIsPostProcessingRunning && CloseableReference.isValid(this.mOriginalImageRef)) {
                    this.mIsPostProcessingRunning = true;
                    shouldExecutePostProcessing = true;
                }
            }
            if (shouldExecutePostProcessing) {
                this.executeCopyAndPostprocessBitmap();
            }
        }

        private void executeCopyAndPostprocessBitmap() {
            PostprocessorProducer.this.mExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean shouldExecutePostprocessing;
                    CloseableReference closeableImageRef = null;
                    RepeatedPostprocessorConsumer repeatedPostprocessorConsumer = RepeatedPostprocessorConsumer.this;
                    synchronized (repeatedPostprocessorConsumer) {
                        RepeatedPostprocessorConsumer.this.mIsDirty = false;
                        if (CloseableReference.isValid((CloseableReference)RepeatedPostprocessorConsumer.this.mOriginalImageRef)) {
                            closeableImageRef = RepeatedPostprocessorConsumer.this.mOriginalImageRef.clone();
                        }
                    }
                    if (closeableImageRef != null) {
                        try {
                            RepeatedPostprocessorConsumer.this.copyAndPostprocessBitmap((CloseableReference<CloseableImage>)closeableImageRef, false);
                        }
                        finally {
                            CloseableReference.closeSafely((CloseableReference)closeableImageRef);
                        }
                    }
                    RepeatedPostprocessorConsumer repeatedPostprocessorConsumer2 = RepeatedPostprocessorConsumer.this;
                    synchronized (repeatedPostprocessorConsumer2) {
                        shouldExecutePostprocessing = RepeatedPostprocessorConsumer.this.mIsDirty;
                        RepeatedPostprocessorConsumer.this.mIsPostProcessingRunning = RepeatedPostprocessorConsumer.this.mIsDirty;
                    }
                    if (shouldExecutePostprocessing) {
                        RepeatedPostprocessorConsumer.this.executeCopyAndPostprocessBitmap();
                    }
                }
            });
        }

        private synchronized void closeOriginalImage() {
            CloseableReference.closeSafely(this.mOriginalImageRef);
            this.mOriginalImageRef = null;
        }
    }

    private class SingleUsePostprocessorConsumer
    extends AbstractPostprocessorConsumer {
        private SingleUsePostprocessorConsumer(Consumer<CloseableReference<CloseableImage>> consumer, ProducerListener listener, String requestId, Postprocessor postprocessor) {
            super(consumer, listener, requestId, postprocessor);
        }

        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, final boolean isLast) {
            if (!isLast) {
                return;
            }
            if (!PostprocessorProducer.this.mCloseableImageCopier.isCloseableImageCopyable(newResult)) {
                this.mConsumer.onNewResult(newResult, true);
                return;
            }
            final CloseableReference clonedResult = newResult.clone();
            PostprocessorProducer.this.mExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SingleUsePostprocessorConsumer.this.copyAndPostprocessBitmap((CloseableReference<CloseableImage>)clonedResult, isLast);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)clonedResult);
                    }
                }
            });
        }
    }

    private abstract class AbstractPostprocessorConsumer
    extends BaseConsumer<CloseableReference<CloseableImage>> {
        protected final Consumer<CloseableReference<CloseableImage>> mConsumer;
        private final ProducerListener mListener;
        private final String mRequestId;
        private final Postprocessor mPostprocessor;

        private AbstractPostprocessorConsumer(Consumer<CloseableReference<CloseableImage>> consumer, ProducerListener listener, String requestId, Postprocessor postprocessor) {
            this.mConsumer = consumer;
            this.mListener = listener;
            this.mRequestId = requestId;
            this.mPostprocessor = postprocessor;
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            this.mConsumer.onFailure(t);
        }

        @Override
        protected void onCancellationImpl() {
            this.mConsumer.onCancellation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void copyAndPostprocessBitmap(CloseableReference<CloseableImage> sourceImageRef, boolean isLast) {
            this.mListener.onProducerStart(this.mRequestId, PostprocessorProducer.NAME);
            CloseableReference<CloseableImage> destRef = null;
            try {
                try {
                    destRef = PostprocessorProducer.this.mCloseableImageCopier.copyCloseableImage(sourceImageRef);
                    this.mListener.onProducerEvent(this.mRequestId, PostprocessorProducer.NAME, PostprocessorProducer.BITMAP_COPIED_EVENT);
                    this.postprocessBitmap(destRef, this.mPostprocessor);
                }
                catch (Throwable t) {
                    this.mListener.onProducerFinishWithFailure(this.mRequestId, PostprocessorProducer.NAME, t, this.getExtraMap(this.mListener, this.mRequestId, this.mPostprocessor));
                    this.mConsumer.onFailure(t);
                    CloseableReference.closeSafely(destRef);
                    return;
                }
                this.mListener.onProducerFinishWithSuccess(this.mRequestId, PostprocessorProducer.NAME, this.getExtraMap(this.mListener, this.mRequestId, this.mPostprocessor));
                this.mConsumer.onNewResult(destRef, isLast);
            }
            finally {
                CloseableReference.closeSafely(destRef);
            }
        }

        private void postprocessBitmap(CloseableReference<CloseableImage> destinationCloseableImageRef, Postprocessor postprocessor) {
            Bitmap destinationBitmap = ((CloseableBitmap)destinationCloseableImageRef.get()).getUnderlyingBitmap();
            postprocessor.process(destinationBitmap);
        }

        private Map<String, String> getExtraMap(ProducerListener listener, String requestId, Postprocessor postprocessor) {
            if (!listener.requiresExtraMap(requestId)) {
                return null;
            }
            return ImmutableMap.of((Object)PostprocessorProducer.POSTPROCESSOR, (Object)postprocessor.getName());
        }
    }
}

