/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.os.SystemClock;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.NfpRequestState;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class NetworkFetchProducer<RS extends NfpRequestState>
implements Producer<CloseableReference<PooledByteBuffer>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "NetworkFetchProducer";
    public static final String INTERMEDIATE_RESULT_PRODUCER_EVENT = "intermediate_result";
    private static final int READ_SIZE = 16384;
    @VisibleForTesting
    static final long TIME_BETWEEN_PARTIAL_RESULTS_MS = 100L;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final ByteArrayPool mByteArrayPool;

    public NetworkFetchProducer(PooledByteBufferFactory pooledByteBufferFactory, ByteArrayPool byteArrayPool) {
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mByteArrayPool = byteArrayPool;
    }

    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext context) {
        context.getListener().onProducerStart(context.getId(), this.getProducerName());
        RS requestState = this.newRequestState(consumer, context);
        this.fetchImage(requestState);
    }

    protected abstract RS newRequestState(Consumer<CloseableReference<PooledByteBuffer>> var1, ProducerContext var2);

    protected abstract void fetchImage(RS var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResult(RS requestState, InputStream responseData, int responseContentLength, boolean propagateIntermediateResults) throws IOException {
        PooledByteBufferOutputStream pooledOutputStream = responseContentLength > 0 ? this.mPooledByteBufferFactory.newOutputStream(responseContentLength) : this.mPooledByteBufferFactory.newOutputStream();
        byte[] ioArray = (byte[])this.mByteArrayPool.get(16384);
        try {
            int length;
            while ((length = responseData.read(ioArray)) >= 0) {
                if (length <= 0) continue;
                pooledOutputStream.write(ioArray, 0, length);
                if (!propagateIntermediateResults) continue;
                this.maybeHandleIntermediateResult(pooledOutputStream, (NfpRequestState)requestState);
            }
            this.handleFinalResult(pooledOutputStream, requestState);
        }
        finally {
            this.mByteArrayPool.release(ioArray);
            pooledOutputStream.close();
        }
    }

    private void maybeHandleIntermediateResult(PooledByteBufferOutputStream pooledOutputStream, NfpRequestState requestState) {
        long nowMs = SystemClock.elapsedRealtime();
        if (nowMs - requestState.getLastIntermediateResultTimeMs() >= 100L) {
            requestState.setLastIntermediateResultTimeMs(nowMs);
            requestState.getListener().onProducerEvent(requestState.getId(), this.getProducerName(), INTERMEDIATE_RESULT_PRODUCER_EVENT);
            this.passResultToConsumer(pooledOutputStream, false, requestState.getConsumer());
        }
    }

    protected void handleFinalResult(PooledByteBufferOutputStream pooledOutputStream, RS requestState) {
        ((NfpRequestState)requestState).getListener().onProducerFinishWithSuccess(((NfpRequestState)requestState).getId(), this.getProducerName(), this.getExtraMap(pooledOutputStream.size(), requestState));
        this.passResultToConsumer(pooledOutputStream, true, ((NfpRequestState)requestState).getConsumer());
    }

    @VisibleForTesting
    void passResultToConsumer(PooledByteBufferOutputStream pooledOutputStream, boolean isFinal, Consumer<CloseableReference<PooledByteBuffer>> consumer) {
        CloseableReference result = CloseableReference.of((Closeable)pooledOutputStream.toByteBuffer());
        consumer.onNewResult((CloseableReference<PooledByteBuffer>)result, isFinal);
        result.close();
    }

    @Nullable
    private Map<String, String> getExtraMap(int byteSize, RS requestState) {
        if (!((NfpRequestState)requestState).getListener().requiresExtraMap(((NfpRequestState)requestState).getId())) {
            return null;
        }
        return this.buildExtraMapForFinalResult(byteSize, requestState);
    }

    @Nullable
    protected Map<String, String> buildExtraMapForFinalResult(int byteSize, RS requestState) {
        return null;
    }

    protected void onFailure(RS requestState, Throwable e, Map<String, String> extraMap) {
        ((NfpRequestState)requestState).getListener().onProducerFinishWithFailure(((NfpRequestState)requestState).getId(), this.getProducerName(), e, extraMap);
        ((NfpRequestState)requestState).getConsumer().onFailure(e);
    }

    protected void onCancellation(RS requestState, Map<String, String> extraMap) {
        ((NfpRequestState)requestState).getListener().onProducerFinishWithCancellation(((NfpRequestState)requestState).getId(), this.getProducerName(), extraMap);
        ((NfpRequestState)requestState).getConsumer().onCancellation();
    }
}

