/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;

public abstract class MemoryCacheProducer<K, T>
implements Producer<CloseableReference<T>> {
    @VisibleForTesting
    static final String CACHED_VALUE_FOUND = "cached_value_found";
    protected final MemoryCache<K, T, Void> mMemoryCache;
    protected final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<T>> mNextProducer;

    protected MemoryCacheProducer(MemoryCache<K, T, Void> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<T>> nextProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(final Consumer<CloseableReference<T>> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        listener.onProducerStart(requestId, this.getProducerName());
        final K cacheKey = this.getCacheKey(producerContext.getImageRequest());
        CloseableReference<T> cachedReference = this.mMemoryCache.get(cacheKey, null);
        if (cachedReference != null) {
            boolean shouldStartNextProducer = this.shouldStartNextProducer(cachedReference);
            if (!shouldStartNextProducer) {
                listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)CACHED_VALUE_FOUND, (Object)"true") : null);
            }
            consumer.onNewResult(cachedReference, !shouldStartNextProducer);
            cachedReference.close();
            if (!shouldStartNextProducer) {
                return;
            }
        }
        BaseConsumer consumerOfNextProducer = !this.shouldCacheReturnedValues() ? consumer : new BaseConsumer<CloseableReference<T>>(){

            @Override
            public void onNewResultImpl(CloseableReference<T> newResult, boolean isLast) {
                CloseableReference cachedResult = null;
                if (newResult != null && MemoryCacheProducer.this.shouldCacheResult(newResult, cacheKey, isLast)) {
                    cachedResult = MemoryCacheProducer.this.mMemoryCache.cache(cacheKey, newResult);
                }
                if (cachedResult != null) {
                    consumer.onNewResult(cachedResult, isLast);
                    cachedResult.close();
                } else {
                    consumer.onNewResult(newResult, isLast);
                }
            }

            @Override
            public void onFailureImpl(Throwable t) {
                consumer.onFailure(t);
            }

            @Override
            protected void onCancellationImpl() {
                consumer.onCancellation();
            }
        };
        listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)CACHED_VALUE_FOUND, (Object)"false") : null);
        this.mNextProducer.produceResults(consumerOfNextProducer, producerContext);
    }

    protected abstract K getCacheKey(ImageRequest var1);

    protected abstract boolean shouldStartNextProducer(CloseableReference<T> var1);

    protected abstract boolean shouldCacheReturnedValues();

    protected abstract boolean shouldCacheResult(CloseableReference<T> var1, K var2, boolean var3);

    protected abstract String getProducerName();
}

