/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import android.os.SystemClock;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.decoder.ProgressiveJpegParser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class DecodeProducer
implements Producer<CloseableReference<CloseableImage>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "DecodeProducer";
    private static final String QUEUE_TIME_KEY = "queueTime";
    private static final String HAS_GOOD_QUALITY_KEY = "hasGoodQuality";
    private static final String IS_FINAL_KEY = "isFinal";
    private final ByteArrayPool mByteArrayPool;
    private final Executor mExecutor;
    private final ImageDecoder mImageDecoder;
    private final ProgressiveJpegConfig mProgressiveJpegConfig;
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public DecodeProducer(ByteArrayPool byteArrayPool, Executor executor, ImageDecoder imageDecoder, ProgressiveJpegConfig progressiveJpegConfig, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mByteArrayPool = (ByteArrayPool)Preconditions.checkNotNull((Object)byteArrayPool);
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mImageDecoder = (ImageDecoder)Preconditions.checkNotNull((Object)imageDecoder);
        this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext context) {
        ProgressiveDecoder progressiveDecoder;
        ImageRequest imageRequest = context.getImageRequest();
        if (!UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri())) {
            progressiveDecoder = new LocalImagesProgressiveDecoder(consumer, context);
        } else {
            ProgressiveJpegParser jpegParser = new ProgressiveJpegParser(this.mByteArrayPool);
            progressiveDecoder = new NetworkImagesProgressiveDecoder(consumer, context, jpegParser, this.mProgressiveJpegConfig);
        }
        this.mNextProducer.produceResults(progressiveDecoder, context);
    }

    class NetworkImagesProgressiveDecoder
    extends ProgressiveDecoder {
        private final ProgressiveJpegParser mProgressiveJpegParser;
        private final ProgressiveJpegConfig mProgressiveJpegConfig;
        private int mLastDecodedScanNumber;

        NetworkImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, ProgressiveJpegParser progressiveJpegParser, ProgressiveJpegConfig progressiveJpegConfig) {
            super(consumer, producerContext);
            this.mProgressiveJpegParser = (ProgressiveJpegParser)Preconditions.checkNotNull((Object)progressiveJpegParser);
            this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
            this.mLastDecodedScanNumber = 0;
        }

        @Override
        protected void maybeDecodeIntermediateImage(CloseableReference<PooledByteBuffer> imageBytesRef) {
            Preconditions.checkNotNull(imageBytesRef);
            if (this.mProgressiveJpegParser.parseMoreData(imageBytesRef) && this.mProgressiveJpegParser.getBestScanNumber() >= this.mProgressiveJpegConfig.getNextScanNumberToDecode(this.mLastDecodedScanNumber)) {
                this.mLastDecodedScanNumber = this.mProgressiveJpegParser.getBestScanNumber();
                super.maybeDecodeIntermediateImage(imageBytesRef);
            }
        }

        @Override
        @Nullable
        protected ImageFormat getImageFormat(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return this.mProgressiveJpegParser.isJpeg() ? ImageFormat.JPEG : ImageFormat.UNKNOWN;
        }

        @Override
        protected int getIntermediateImageEndOffset(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return this.mProgressiveJpegParser.getBestScanEndOffset();
        }

        @Override
        protected QualityInfo getQualityInfo(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return this.mProgressiveJpegConfig.getQualityInfo(this.mProgressiveJpegParser.getBestScanNumber());
        }
    }

    class LocalImagesProgressiveDecoder
    extends ProgressiveDecoder {
        @VisibleForTesting
        LocalImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
            super(consumer, producerContext);
        }

        @Override
        @Nullable
        protected ImageFormat getImageFormat(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return null;
        }

        @Override
        protected int getIntermediateImageEndOffset(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return ((PooledByteBuffer)imageBytesRef.get()).size();
        }

        @Override
        protected QualityInfo getQualityInfo(CloseableReference<PooledByteBuffer> imageBytesRef) {
            return ImmutableQualityInfo.of(0, false, false);
        }
    }

    @VisibleForTesting
    abstract class ProgressiveDecoder
    extends BaseConsumer<CloseableReference<PooledByteBuffer>> {
        private final Consumer<CloseableReference<CloseableImage>> mConsumer;
        protected final ProducerContext mProducerContext;
        private final ProducerListener mProducerListener;
        private final ImageDecodeOptions mImageDecodeOptions;
        @GuardedBy(value="this")
        private boolean mIsFinished;
        @GuardedBy(value="ProgressiveDecoder.this")
        @VisibleForTesting
        CloseableReference<PooledByteBuffer> mStoredIntermediateImageBytesRef;
        @GuardedBy(value="ProgressiveDecoder.this")
        @VisibleForTesting
        int mStoredIntermediateImageBestScanEnd;
        @GuardedBy(value="ProgressiveDecoder.this")
        @VisibleForTesting
        ImageFormat mStoredIntermediateImageFormat;
        @GuardedBy(value="ProgressiveDecoder.this")
        @VisibleForTesting
        QualityInfo mStoredIntermediateImageQualityInfo;

        public ProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
            this.mConsumer = consumer;
            this.mProducerContext = producerContext;
            this.mProducerListener = producerContext.getListener();
            this.mImageDecodeOptions = producerContext.getImageRequest().getImageDecodeOptions();
            this.mIsFinished = false;
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (ProgressiveDecoder.this.mProducerContext.isIntermediateResultExpected()) {
                        ProgressiveDecoder.this.maybeScheduleStoredIntermediateImageDecode();
                    }
                }
            });
        }

        private synchronized void maybeScheduleStoredIntermediateImageDecode() {
            if (this.mStoredIntermediateImageBytesRef != null) {
                this.scheduleImageDecode(this.mStoredIntermediateImageBytesRef, this.mStoredIntermediateImageBestScanEnd, this.mStoredIntermediateImageFormat, this.mStoredIntermediateImageQualityInfo, false);
                this.closeStoredIntermediateImageBytes();
            }
        }

        protected synchronized void updateStoredIntermediateImage(CloseableReference<PooledByteBuffer> intermediateImageBytesRef, int intermediateImageBestScanEnd, ImageFormat intermediateImageFormat, QualityInfo intermediateImageQualityInfo) {
            this.closeStoredIntermediateImageBytes();
            this.mStoredIntermediateImageBytesRef = intermediateImageBytesRef.clone();
            this.mStoredIntermediateImageBestScanEnd = intermediateImageBestScanEnd;
            this.mStoredIntermediateImageFormat = intermediateImageFormat;
            this.mStoredIntermediateImageQualityInfo = intermediateImageQualityInfo;
        }

        protected synchronized void closeStoredIntermediateImageBytes() {
            if (this.mStoredIntermediateImageBytesRef != null) {
                this.mStoredIntermediateImageBytesRef.close();
                this.mStoredIntermediateImageBytesRef = null;
            }
        }

        @Override
        public void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            if (isLast) {
                this.decodeFinalImage(newResult);
            } else {
                this.maybeDecodeIntermediateImage(newResult);
            }
        }

        @Override
        public void onFailureImpl(Throwable t) {
            this.handleError(t);
        }

        @Override
        public void onCancellationImpl() {
            this.handleCancellation();
        }

        private void decodeFinalImage(CloseableReference<PooledByteBuffer> imageBytesRef) {
            this.closeStoredIntermediateImageBytes();
            if (imageBytesRef == null) {
                this.handleResult(null, true);
            } else {
                this.scheduleImageDecode(imageBytesRef, ((PooledByteBuffer)imageBytesRef.get()).size(), this.getImageFormat(imageBytesRef), ImmutableQualityInfo.FULL_QUALITY, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void maybeDecodeIntermediateImage(CloseableReference<PooledByteBuffer> imageBytesRef) {
            Preconditions.checkNotNull(imageBytesRef);
            int bestScanEnd = this.getIntermediateImageEndOffset(imageBytesRef);
            ImageFormat imageFormat = this.getImageFormat(imageBytesRef);
            QualityInfo qualityInfo = this.getQualityInfo(imageBytesRef);
            ProgressiveDecoder progressiveDecoder = this;
            synchronized (progressiveDecoder) {
                if (!this.mProducerContext.isIntermediateResultExpected()) {
                    this.updateStoredIntermediateImage(imageBytesRef, bestScanEnd, imageFormat, qualityInfo);
                } else {
                    this.closeStoredIntermediateImageBytes();
                    this.scheduleImageDecode(imageBytesRef, bestScanEnd, imageFormat, qualityInfo, false);
                }
            }
        }

        protected void scheduleImageDecode(CloseableReference<PooledByteBuffer> imageBytesRef, final int length, final @Nullable ImageFormat imageFormat, final QualityInfo qualityInfo, final boolean isFinal) {
            final CloseableReference imageBytesRefCopy = imageBytesRef.clone();
            final long startTime = SystemClock.elapsedRealtime();
            DecodeProducer.this.mExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long queueTime = SystemClock.elapsedRealtime() - startTime;
                    try {
                        if (ProgressiveDecoder.this.isFinished()) {
                            return;
                        }
                        ProgressiveDecoder.this.mProducerListener.onProducerStart(ProgressiveDecoder.this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME);
                        CloseableImage decodedImage = DecodeProducer.this.mImageDecoder.decodeImage((CloseableReference<PooledByteBuffer>)imageBytesRefCopy, imageFormat, length, qualityInfo, ProgressiveDecoder.this.mImageDecodeOptions);
                        ProgressiveDecoder.this.mProducerListener.onProducerFinishWithSuccess(ProgressiveDecoder.this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME, ProgressiveDecoder.this.getExtraMap(queueTime, qualityInfo, isFinal));
                        ProgressiveDecoder.this.handleResult(decodedImage, isFinal);
                    }
                    catch (Exception e) {
                        ProgressiveDecoder.this.mProducerListener.onProducerFinishWithFailure(ProgressiveDecoder.this.mProducerContext.getId(), DecodeProducer.PRODUCER_NAME, e, ProgressiveDecoder.this.getExtraMap(queueTime, qualityInfo, isFinal));
                        ProgressiveDecoder.this.handleError(e);
                    }
                    finally {
                        imageBytesRefCopy.close();
                    }
                }
            });
        }

        private Map<String, String> getExtraMap(long queueTime, QualityInfo qualityInfo, boolean isFinal) {
            if (!this.mProducerListener.requiresExtraMap(this.mProducerContext.getId())) {
                return null;
            }
            return ImmutableMap.of((Object)DecodeProducer.QUEUE_TIME_KEY, (Object)String.valueOf(queueTime), (Object)DecodeProducer.HAS_GOOD_QUALITY_KEY, (Object)String.valueOf(qualityInfo.isOfGoodEnoughQuality()), (Object)DecodeProducer.IS_FINAL_KEY, (Object)String.valueOf(isFinal));
        }

        private synchronized boolean isFinished() {
            return this.mIsFinished;
        }

        private synchronized void maybeFinish(boolean finish) {
            if (this.mIsFinished) {
                return;
            }
            this.mIsFinished = finish;
            if (finish) {
                this.closeStoredIntermediateImageBytes();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResult(CloseableImage decodedImage, boolean isFinal) {
            CloseableReference decodedImageRef = CloseableReference.of((Closeable)decodedImage);
            try {
                this.maybeFinish(isFinal);
                this.mConsumer.onNewResult((CloseableReference<CloseableImage>)decodedImageRef, isFinal);
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)decodedImageRef);
            }
        }

        private void handleError(Throwable t) {
            this.maybeFinish(true);
            this.mConsumer.onFailure(t);
        }

        private void handleCancellation() {
            this.maybeFinish(true);
            this.mConsumer.onCancellation();
        }

        @Nullable
        protected abstract ImageFormat getImageFormat(CloseableReference<PooledByteBuffer> var1);

        protected abstract int getIntermediateImageEndOffset(CloseableReference<PooledByteBuffer> var1);

        protected abstract QualityInfo getQualityInfo(CloseableReference<PooledByteBuffer> var1);
    }
}

