/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;

public class BranchOnSeparateImagesProducer
implements Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
    private final Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> mNextProducer1;
    private final Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> mNextProducer2;

    public BranchOnSeparateImagesProducer(Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> nextProducer1, Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> nextProducer2) {
        this.mNextProducer1 = nextProducer1;
        this.mNextProducer2 = nextProducer2;
    }

    @Override
    public void produceResults(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext context) {
        OnFirstImageConsumer onFirstImageConsumer = new OnFirstImageConsumer(consumer, context);
        this.mNextProducer1.produceResults(onFirstImageConsumer, context);
    }

    private class OnFirstImageConsumer
    extends BaseConsumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
        private Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> mConsumer;
        private ProducerContext mProducerContext;

        private OnFirstImageConsumer(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext producerContext) {
            this.mConsumer = consumer;
            this.mProducerContext = producerContext;
        }

        @Override
        protected void onNewResultImpl(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> newResult, boolean isLast) {
            boolean isGoodEnough = this.isResultGoodEnough(newResult, this.mProducerContext.getImageRequest());
            if (newResult != null && (isGoodEnough || this.mProducerContext.getImageRequest().getLocalThumbnailPreviewsEnabled())) {
                this.mConsumer.onNewResult(newResult, isLast && isGoodEnough);
            }
            if (isLast && !isGoodEnough) {
                BranchOnSeparateImagesProducer.this.mNextProducer2.produceResults(this.mConsumer, this.mProducerContext);
            }
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            BranchOnSeparateImagesProducer.this.mNextProducer2.produceResults(this.mConsumer, this.mProducerContext);
        }

        @Override
        protected void onCancellationImpl() {
            this.mConsumer.onCancellation();
        }

        private boolean isResultGoodEnough(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> newResult, ImageRequest imageRequest) {
            if (newResult == null) {
                return false;
            }
            ImageTransformMetaData metaData = (ImageTransformMetaData)newResult.second;
            return metaData.getWidth() >= imageRequest.getPreferredWidth() && metaData.getHeight() >= imageRequest.getPreferredHeight();
        }
    }
}

