/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheKey;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.MemoryCacheProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.request.ImageRequest;

public class BitmapMemoryCacheProducer
extends MemoryCacheProducer<BitmapMemoryCacheKey, CloseableImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "BitmapMemoryCacheProducer";

    public BitmapMemoryCacheProducer(MemoryCache<BitmapMemoryCacheKey, CloseableImage, Void> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<CloseableImage>> nextProducer) {
        super(memoryCache, cacheKeyFactory, nextProducer);
    }

    @Override
    protected BitmapMemoryCacheKey getCacheKey(ImageRequest imageRequest) {
        return this.mCacheKeyFactory.getBitmapCacheKey(imageRequest);
    }

    @Override
    protected boolean shouldStartNextProducer(CloseableReference<CloseableImage> cachedResultFound) {
        return !((CloseableImage)cachedResultFound.get()).getQualityInfo().isOfFullQuality();
    }

    @Override
    protected boolean shouldCacheReturnedValues() {
        return true;
    }

    @Override
    protected boolean shouldCacheResult(CloseableReference<CloseableImage> result, BitmapMemoryCacheKey cacheKey, boolean isLast) {
        if (((CloseableImage)result.get()).isStateful()) {
            return false;
        }
        return isLast || this.shouldCacheIntermediateResult(result, cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCacheIntermediateResult(CloseableReference<CloseableImage> newResult, BitmapMemoryCacheKey cacheKey) {
        CloseableReference currentCachedResult = this.mMemoryCache.get(cacheKey, null);
        if (currentCachedResult == null) {
            return true;
        }
        try {
            QualityInfo currentQualityInfo = ((CloseableImage)currentCachedResult.get()).getQualityInfo();
            boolean bl = !currentQualityInfo.isOfFullQuality() && ((CloseableImage)newResult.get()).getQualityInfo().getQuality() > currentQualityInfo.getQuality();
            return bl;
        }
        finally {
            CloseableReference.closeSafely(currentCachedResult);
        }
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

