/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.references.OOMSoftReference;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.SingleByteArrayPoolStatsTracker;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SingleByteArrayPool
implements ByteArrayPool {
    private static final Class<?> TAG = SingleByteArrayPool.class;
    @VisibleForTesting
    final int mMinByteArraySize;
    @VisibleForTesting
    final int mMaxByteArraySize;
    @VisibleForTesting
    final SingleByteArrayPoolStatsTracker mSingleByteArrayPoolStatsTracker;
    @GuardedBy(value="this")
    @VisibleForTesting
    OOMSoftReference<byte[]> mByteArraySoftRef;
    @GuardedBy(value="this")
    @VisibleForTesting
    boolean mInUse = false;

    public SingleByteArrayPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams params, SingleByteArrayPoolStatsTracker singleByteArrayPoolStatsTracker) {
        this(memoryTrimmableRegistry, singleByteArrayPoolStatsTracker, params.minBucketSize, params.maxBucketSize);
    }

    @VisibleForTesting
    SingleByteArrayPool(MemoryTrimmableRegistry memoryTrimmableRegistry, SingleByteArrayPoolStatsTracker singleByteArrayPoolStatsTracker, int minByteArraySize, int maxByteArraySize) {
        Preconditions.checkNotNull((Object)memoryTrimmableRegistry);
        Preconditions.checkNotNull((Object)singleByteArrayPoolStatsTracker);
        Preconditions.checkState((minByteArraySize > 0 && maxByteArraySize >= minByteArraySize ? 1 : 0) != 0);
        this.mSingleByteArrayPoolStatsTracker = singleByteArrayPoolStatsTracker;
        this.mMaxByteArraySize = maxByteArraySize;
        this.mMinByteArraySize = minByteArraySize;
        this.mByteArraySoftRef = new OOMSoftReference();
        memoryTrimmableRegistry.registerMemoryTrimmable((MemoryTrimmable)this);
    }

    @Override
    public synchronized byte[] get(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size %s", (Object[])new Object[]{size});
        Preconditions.checkState((!this.mInUse ? 1 : 0) != 0, (Object)"Byte-array currently in use");
        int bucketedSize = this.getBucketedSize(size);
        this.mSingleByteArrayPoolStatsTracker.onBucketedSizeRequested(bucketedSize);
        if (bucketedSize > this.mMaxByteArraySize) {
            throw new IllegalArgumentException("Size too large: " + size);
        }
        byte[] byteArray = (byte[])this.mByteArraySoftRef.get();
        if (byteArray == null || byteArray.length < bucketedSize) {
            bucketedSize = Math.max(bucketedSize, this.mMinByteArraySize);
            if (FLog.isLoggable((int)2)) {
                FLog.v(TAG, (String)"get (alloc) size = %d. Previous buffer size = %d", (Object)bucketedSize, (Object)(byteArray == null ? 0 : byteArray.length));
            }
            if (byteArray != null) {
                byteArray = null;
                this.clearByteArraySoftRef();
            }
            this.allocateByteArraySoftRef(bucketedSize);
            byteArray = (byte[])this.mByteArraySoftRef.get();
        }
        this.mInUse = true;
        return byteArray;
    }

    @Override
    public synchronized void release(byte[] value) {
        Preconditions.checkNotNull((Object)value);
        if (this.mByteArraySoftRef.get() == value) {
            this.mInUse = false;
        }
    }

    public synchronized void trim(MemoryTrimType trimType) {
        if (!this.mInUse && this.mByteArraySoftRef.get() != null) {
            if (FLog.isLoggable((int)2)) {
                FLog.v(TAG, (String)"Discarding existing buffer of size %d", (Object)((byte[])this.mByteArraySoftRef.get()).length);
            }
            this.mSingleByteArrayPoolStatsTracker.onMemoryTrimmed(((byte[])this.mByteArraySoftRef.get()).length);
            this.clearByteArraySoftRef();
        }
    }

    @VisibleForTesting
    int getBucketedSize(int size) {
        int powerOfTwo = Integer.highestOneBit(size);
        return size > powerOfTwo ? powerOfTwo * 2 : powerOfTwo;
    }

    private synchronized void allocateByteArraySoftRef(int bucketedSize) {
        byte[] byteArray = new byte[bucketedSize];
        this.mByteArraySoftRef.set((Object)byteArray);
        this.mSingleByteArrayPoolStatsTracker.onMemoryAlloc(bucketedSize);
    }

    private synchronized void clearByteArraySoftRef() {
        this.mByteArraySoftRef.clear();
    }
}

