/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.NativeMemoryChunk;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NativeMemoryChunkInputStream
extends InputStream {
    @VisibleForTesting
    final NativeMemoryChunk mMemoryChunk;
    @VisibleForTesting
    final int mEndOffset;
    @VisibleForTesting
    final int mStartOffset;
    @VisibleForTesting
    int mOffset;
    @VisibleForTesting
    int mMark;
    byte[] mSingleByteBuffer = new byte[1];

    public NativeMemoryChunkInputStream(NativeMemoryChunk nativeMemoryChunk, int startOffset, int length) {
        Preconditions.checkState((startOffset >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((length >= 0 ? 1 : 0) != 0);
        this.mMemoryChunk = (NativeMemoryChunk)Preconditions.checkNotNull((Object)nativeMemoryChunk);
        this.mStartOffset = startOffset;
        this.mEndOffset = startOffset + length > nativeMemoryChunk.getSize() ? nativeMemoryChunk.getSize() : startOffset + length;
        this.mOffset = startOffset;
        this.mMark = startOffset;
    }

    @Override
    public int available() {
        return Math.max(0, this.mEndOffset - this.mOffset);
    }

    @Override
    public void mark(int readlimit) {
        this.mMark = this.mOffset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int len = this.read(this.mSingleByteBuffer, 0, 1);
        int b = this.mSingleByteBuffer[0] & 0xFF;
        return len == 1 ? b : -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + length);
        }
        if (this.mOffset >= this.mEndOffset) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int numToRead = Math.min(this.available(), length);
        int numRead = this.mMemoryChunk.read(this.mOffset, buffer, offset, numToRead);
        this.mOffset += numRead;
        return numRead;
    }

    @Override
    public void reset() {
        this.mOffset = this.mMark;
    }

    @Override
    public long skip(long byteCount) {
        if (byteCount <= 0L || this.mOffset >= this.mEndOffset) {
            return 0L;
        }
        int temp = this.mOffset;
        this.mOffset = (long)(this.mEndOffset - this.mOffset) < byteCount ? this.mEndOffset : (int)((long)this.mOffset + byteCount);
        return Math.max(0, this.mOffset - temp);
    }
}

