/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import java.util.List;

public class SimpleProgressiveJpegConfig
implements ProgressiveJpegConfig {
    private final List<Integer> mScansToDecode;
    private final int mGoodEnoughScanNumber;

    public SimpleProgressiveJpegConfig(List<Integer> scansToDecode, int goodEnoughScanNumber) {
        this.mScansToDecode = scansToDecode;
        this.mGoodEnoughScanNumber = goodEnoughScanNumber;
    }

    @Override
    public int getNextScanNumberToDecode(int scanNumber) {
        for (int i = 0; i < this.mScansToDecode.size(); ++i) {
            if (this.mScansToDecode.get(i) <= scanNumber) continue;
            return this.mScansToDecode.get(i);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public QualityInfo getQualityInfo(int scanNumber) {
        return ImmutableQualityInfo.of(scanNumber, scanNumber >= this.mGoodEnoughScanNumber, false);
    }
}

