/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import android.os.Build;
import android.util.Pair;
import com.facebook.common.internal.Maps;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.AddImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheKeyMultiplexProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.BranchOnSeparateImagesProducer;
import com.facebook.imagepipeline.producers.DecodeProducer;
import com.facebook.imagepipeline.producers.EncodedMemoryCacheProducer;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.LocalAssetFetchProducer;
import com.facebook.imagepipeline.producers.LocalContentUriFetchProducer;
import com.facebook.imagepipeline.producers.LocalExifThumbnailProducer;
import com.facebook.imagepipeline.producers.LocalFileFetchProducer;
import com.facebook.imagepipeline.producers.LocalResourceFetchProducer;
import com.facebook.imagepipeline.producers.LocalVideoThumbnailProducer;
import com.facebook.imagepipeline.producers.NetworkFetchProducer;
import com.facebook.imagepipeline.producers.PostprocessorProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ResizeAndRotateProducer;
import com.facebook.imagepipeline.producers.SwallowResultProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducer;
import com.facebook.imagepipeline.producers.ThrottlingProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Map;

public class ProducerSequenceFactory {
    private static final int MAX_SIMULTANEOUS_FILE_FETCH_AND_RESIZE = 5;
    private final ProducerFactory mProducerFactory;
    private final NetworkFetchProducer mNetworkFetchProducer;
    private final boolean mResizeAndRotateEnabledForNetwork;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mBitmapCacheGetOnlySequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mNetworkFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<PooledByteBuffer>> mBackgroundNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<Void> mNetworkFetchToEncodedMemoryPrefetchSequence;
    private Producer<CloseableReference<PooledByteBuffer>> mCommonNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalImageFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalVideoFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalContentUriFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalResourceFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalAssetFetchSequence;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> mPostprocessorSequences;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> mCloseableImagePrefetchSequences;

    public ProducerSequenceFactory(ProducerFactory producerFactory, NetworkFetchProducer networkFetchProducer, boolean resizeAndRotateEnabledForNetwork) {
        this.mProducerFactory = producerFactory;
        this.mNetworkFetchProducer = networkFetchProducer;
        this.mResizeAndRotateEnabledForNetwork = resizeAndRotateEnabledForNetwork;
        this.mPostprocessorSequences = Maps.newHashMap();
        this.mCloseableImagePrefetchSequences = Maps.newHashMap();
    }

    public Producer<CloseableReference<PooledByteBuffer>> getEncodedImageProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        return this.getBackgroundNetworkFetchToEncodedMemorySequence();
    }

    public Producer<Void> getEncodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        return this.getNetworkFetchToEncodedMemoryPrefetchSequence();
    }

    private static void validateEncodedImageRequest(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        Preconditions.checkArgument((boolean)UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()));
        Preconditions.checkArgument((imageRequest.getLowestPermittedRequestLevel() == ImageRequest.RequestLevel.FULL_FETCH ? 1 : 0) != 0);
    }

    public synchronized Producer<CloseableReference<CloseableImage>> getBitmapCacheGetOnlySequence() {
        if (this.mBitmapCacheGetOnlySequence == null) {
            ProducerSequenceFactory producerSequenceFactory = this;
            this.mBitmapCacheGetOnlySequence = this.mProducerFactory.newBitmapMemoryCacheGetProducer(producerSequenceFactory.mProducerFactory.newNullProducer());
        }
        return this.mBitmapCacheGetOnlySequence;
    }

    public Producer<CloseableReference<CloseableImage>> getDecodedImageProducerSequence(ImageRequest imageRequest) {
        Producer<CloseableReference<CloseableImage>> pipelineSequence = this.getBasicDecodedImageSequence(imageRequest);
        if (imageRequest.getPostprocessor() != null) {
            return this.getPostprocessorSequence(pipelineSequence);
        }
        return pipelineSequence;
    }

    public Producer<Void> getDecodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        return this.getDecodedImagePrefetchSequence(this.getBasicDecodedImageSequence(imageRequest));
    }

    private Producer<CloseableReference<CloseableImage>> getBasicDecodedImageSequence(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        ImageRequest.RequestLevel lowestPermittedRequestLevel = imageRequest.getLowestPermittedRequestLevel();
        Preconditions.checkState((lowestPermittedRequestLevel.equals((Object)ImageRequest.RequestLevel.FULL_FETCH) || lowestPermittedRequestLevel.equals((Object)ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE) ? 1 : 0) != 0, (String)"Only support bitmap memory cache or full fetch at present, request level is %s ", (Object[])new Object[]{lowestPermittedRequestLevel});
        if (lowestPermittedRequestLevel.equals((Object)ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE)) {
            return this.getBitmapCacheGetOnlySequence();
        }
        Uri uri = imageRequest.getSourceUri();
        if (UriUtil.isNetworkUri((Uri)uri)) {
            return this.getNetworkFetchSequence();
        }
        if (UriUtil.isLocalFileUri((Uri)uri)) {
            if (MediaUtils.isVideo((String)MediaUtils.extractMime((String)uri.getPath()))) {
                return this.getLocalVideoFileFetchSequence();
            }
            return this.getLocalImageFileFetchSequence();
        }
        if (UriUtil.isLocalContentUri((Uri)uri)) {
            return this.getLocalContentUriFetchSequence();
        }
        if (UriUtil.isLocalAssetUri((Uri)uri)) {
            return this.getLocalAssetFetchSequence();
        }
        if (UriUtil.isLocalResourceUri((Uri)uri)) {
            return this.getLocalResourceFetchSequence();
        }
        throw new RuntimeException("Unsupported image type! Uri is: " + uri.toString().substring(0, 30));
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getNetworkFetchSequence() {
        if (this.mNetworkFetchSequence == null) {
            this.mNetworkFetchSequence = this.newBitmapCacheGetToDecodeSequence(this.getCommonNetworkFetchToEncodedMemorySequence());
        }
        return this.mNetworkFetchSequence;
    }

    private synchronized Producer<CloseableReference<PooledByteBuffer>> getBackgroundNetworkFetchToEncodedMemorySequence() {
        if (this.mBackgroundNetworkFetchToEncodedMemorySequence == null) {
            this.mBackgroundNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newBackgroundThreadHandoffProducer(this.getCommonNetworkFetchToEncodedMemorySequence());
        }
        return this.mBackgroundNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<Void> getNetworkFetchToEncodedMemoryPrefetchSequence() {
        if (this.mNetworkFetchToEncodedMemoryPrefetchSequence == null) {
            this.mNetworkFetchToEncodedMemoryPrefetchSequence = ProducerFactory.newSwallowResultProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
        }
        return this.mNetworkFetchToEncodedMemoryPrefetchSequence;
    }

    private synchronized Producer<CloseableReference<PooledByteBuffer>> getCommonNetworkFetchToEncodedMemorySequence() {
        if (this.mCommonNetworkFetchToEncodedMemorySequence == null) {
            this.mCommonNetworkFetchToEncodedMemorySequence = this.newEncodedCacheMultiplexToTranscodeSequence(this.mNetworkFetchProducer, false);
            if (this.mResizeAndRotateEnabledForNetwork) {
                this.mCommonNetworkFetchToEncodedMemorySequence = this.newResizeAndRotateImagesSequence(this.mCommonNetworkFetchToEncodedMemorySequence);
            }
        }
        return this.mCommonNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalImageFileFetchSequence() {
        if (this.mLocalImageFileFetchSequence == null) {
            LocalFileFetchProducer localFileFetchProducer = this.mProducerFactory.newLocalFileFetchProducer();
            this.mLocalImageFileFetchSequence = this.newBitmapCacheGetToTranscodeSequence(localFileFetchProducer, true);
        }
        return this.mLocalImageFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalVideoFileFetchSequence() {
        if (this.mLocalVideoFileFetchSequence == null) {
            LocalVideoThumbnailProducer localVideoThumbnailProducer = this.mProducerFactory.newLocalVideoThumbnailProducer();
            this.mLocalVideoFileFetchSequence = this.newBitmapCacheGetToBitmapCacheSequence(localVideoThumbnailProducer);
        }
        return this.mLocalVideoFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalContentUriFetchSequence() {
        if (this.mLocalContentUriFetchSequence == null) {
            LocalContentUriFetchProducer localContentUriFetchProducer = this.mProducerFactory.newContentUriFetchProducer();
            this.mLocalContentUriFetchSequence = this.newBitmapCacheGetToTranscodeSequence(localContentUriFetchProducer, true);
        }
        return this.mLocalContentUriFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalResourceFetchSequence() {
        if (this.mLocalResourceFetchSequence == null) {
            LocalResourceFetchProducer localResourceFetchProducer = this.mProducerFactory.newLocalResourceFetchProducer();
            this.mLocalResourceFetchSequence = this.newBitmapCacheGetToTranscodeSequence(localResourceFetchProducer, true);
        }
        return this.mLocalResourceFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalAssetFetchSequence() {
        if (this.mLocalAssetFetchSequence == null) {
            LocalAssetFetchProducer localAssetFetchProducer = this.mProducerFactory.newLocalAssetFetchProducer();
            this.mLocalAssetFetchSequence = this.newBitmapCacheGetToTranscodeSequence(localAssetFetchProducer, true);
        }
        return this.mLocalAssetFetchSequence;
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToTranscodeSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer, boolean isLocal) {
        Producer<CloseableReference<PooledByteBuffer>> nextProducerAfterDecode = this.newEncodedCacheMultiplexToTranscodeSequence(nextProducer, isLocal);
        if (isLocal) {
            nextProducerAfterDecode = this.newLocalTransformationsSequence(nextProducerAfterDecode);
        }
        return this.newBitmapCacheGetToDecodeSequence(nextProducerAfterDecode);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToDecodeSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        DecodeProducer decodeProducer = this.mProducerFactory.newDecodeProducer(nextProducer);
        return this.newBitmapCacheGetToBitmapCacheSequence(decodeProducer);
    }

    private Producer<CloseableReference<PooledByteBuffer>> newEncodedCacheMultiplexToTranscodeSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer, boolean isLocal) {
        if (Build.VERSION.SDK_INT < 18) {
            nextProducer = this.mProducerFactory.newWebpTranscodeProducer(nextProducer);
        }
        if (!isLocal) {
            nextProducer = this.mProducerFactory.newDiskCacheProducer(nextProducer);
        }
        EncodedMemoryCacheProducer encodedMemoryCacheProducer = this.mProducerFactory.newEncodedMemoryCacheProducer(nextProducer);
        return this.mProducerFactory.newEncodedCacheKeyMultiplexProducer(encodedMemoryCacheProducer);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToBitmapCacheSequence(Producer<CloseableReference<CloseableImage>> nextProducer) {
        BitmapMemoryCacheProducer bitmapMemoryCacheProducer = this.mProducerFactory.newBitmapMemoryCacheProducer(nextProducer);
        BitmapMemoryCacheKeyMultiplexProducer bitmapKeyMultiplexProducer = this.mProducerFactory.newBitmapMemoryCacheKeyMultiplexProducer(bitmapMemoryCacheProducer);
        ThreadHandoffProducer<CloseableReference<CloseableImage>> threadHandoffProducer = this.mProducerFactory.newBackgroundThreadHandoffProducer(bitmapKeyMultiplexProducer);
        return this.mProducerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
    }

    private Producer<CloseableReference<PooledByteBuffer>> newResizeAndRotateImagesSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(nextProducer);
        ResizeAndRotateProducer networkImageResizeAndRotateProducer = this.mProducerFactory.newResizeAndRotateProducer(addImageTransformMetaDataProducer);
        return ProducerFactory.newRemoveImageTransformMetaDataProducer(networkImageResizeAndRotateProducer);
    }

    private Producer<CloseableReference<PooledByteBuffer>> newLocalTransformationsSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(nextProducer);
        ResizeAndRotateProducer localImageResizeAndRotateProducer = this.mProducerFactory.newResizeAndRotateProducer(addImageTransformMetaDataProducer);
        ThrottlingProducer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> localImageThrottlingProducer = ProducerFactory.newThrottlingProducer(5, localImageResizeAndRotateProducer);
        LocalExifThumbnailProducer localExifThumbnailProducer = this.mProducerFactory.newLocalExifThumbnailProducer();
        ResizeAndRotateProducer exifThumbnailResizeAndRotateProducer = this.mProducerFactory.newResizeAndRotateProducer(localExifThumbnailProducer);
        BranchOnSeparateImagesProducer branchOnSeparateImagesProducer = ProducerFactory.newBranchOnSeparateImagesProducer(exifThumbnailResizeAndRotateProducer, localImageThrottlingProducer);
        return ProducerFactory.newRemoveImageTransformMetaDataProducer(branchOnSeparateImagesProducer);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getPostprocessorSequence(Producer<CloseableReference<CloseableImage>> nextProducer) {
        if (!this.mPostprocessorSequences.containsKey(nextProducer)) {
            PostprocessorProducer postprocessorProducer = this.mProducerFactory.newPostprocessorProducer(nextProducer);
            this.mPostprocessorSequences.put(nextProducer, postprocessorProducer);
        }
        return this.mPostprocessorSequences.get(nextProducer);
    }

    private synchronized Producer<Void> getDecodedImagePrefetchSequence(Producer<CloseableReference<CloseableImage>> nextProducer) {
        if (!this.mCloseableImagePrefetchSequences.containsKey(nextProducer)) {
            SwallowResultProducer<CloseableReference<CloseableImage>> swallowResultProducer = ProducerFactory.newSwallowResultProducer(nextProducer);
            this.mCloseableImagePrefetchSequences.put(nextProducer, swallowResultProducer);
        }
        return this.mCloseableImagePrefetchSequences.get(nextProducer);
    }
}

