/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageDecodeOptions {
    private static final ImageDecodeOptions DEFAULTS = ImageDecodeOptions.newBuilder().build();
    public final int backgroundColor;
    public final boolean forceOldAnimationCode;
    public final boolean decodePreviewFrame;
    public final boolean useLastFrameForPreview;

    ImageDecodeOptions(ImageDecodeOptionsBuilder b) {
        this.backgroundColor = b.getBackgroundColor();
        this.forceOldAnimationCode = b.getForceOldAnimationCode();
        this.decodePreviewFrame = b.getDecodePreviewFrame();
        this.useLastFrameForPreview = b.getUseLastFrameForPreview();
    }

    public static ImageDecodeOptions defaults() {
        return DEFAULTS;
    }

    public static ImageDecodeOptionsBuilder newBuilder() {
        return new ImageDecodeOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageDecodeOptions that = (ImageDecodeOptions)o;
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (this.forceOldAnimationCode != that.forceOldAnimationCode) {
            return false;
        }
        if (this.decodePreviewFrame != that.decodePreviewFrame) {
            return false;
        }
        return this.useLastFrameForPreview == that.useLastFrameForPreview;
    }

    public int hashCode() {
        int result = this.backgroundColor;
        result = 31 * result + (this.forceOldAnimationCode ? 1 : 0);
        return result;
    }
}

