/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.base;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResultBuilder;
import javax.annotation.Nullable;

public class AnimatedImageResult {
    private final AnimatedImage mImage;
    private final int mFrameForPreview;
    @Nullable
    private CloseableReference<Bitmap> mPreviewBitmap;

    AnimatedImageResult(AnimatedImageResultBuilder builder) {
        this.mImage = (AnimatedImage)Preconditions.checkNotNull((Object)builder.getImage());
        this.mFrameForPreview = builder.getFrameForPreview();
        this.mPreviewBitmap = builder.getPreviewBitmap();
    }

    private AnimatedImageResult(AnimatedImage image) {
        this.mImage = (AnimatedImage)Preconditions.checkNotNull((Object)image);
        this.mFrameForPreview = 0;
    }

    public static AnimatedImageResult forAnimatedImage(AnimatedImage image) {
        return new AnimatedImageResult(image);
    }

    public static AnimatedImageResultBuilder newBuilder(AnimatedImage image) {
        return new AnimatedImageResultBuilder(image);
    }

    public AnimatedImage getImage() {
        return this.mImage;
    }

    public int getFrameForPreview() {
        return this.mFrameForPreview;
    }

    public synchronized CloseableReference<Bitmap> getPreviewBitmap() {
        return CloseableReference.cloneOrNull(this.mPreviewBitmap);
    }

    public synchronized void dispose() {
        if (this.mPreviewBitmap != null) {
            this.mPreviewBitmap.close();
            this.mPreviewBitmap = null;
        }
    }
}

