/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.common.internal.ByteStreams;
import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Throwables;
import com.facebook.imageformat.DefaultImageFormatChecker;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u00002\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/imageformat/ImageFormatChecker;", "", "<init>", "()V", "maxHeaderLength", "", "customImageFormatCheckers", "", "Lcom/facebook/imageformat/ImageFormat$FormatChecker;", "defaultFormatChecker", "Lcom/facebook/imageformat/DefaultImageFormatChecker;", "binaryXmlEnabled", "", "setCustomImageFormatCheckers", "setBinaryXmlEnabled", "determineImageFormat", "Lcom/facebook/imageformat/ImageFormat;", "is", "Ljava/io/InputStream;", "updateMaxHeaderLength", "", "Companion", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nImageFormatChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageFormatChecker.kt\ncom/facebook/imageformat/ImageFormatChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1863#2,2:170\n*S KotlinDebug\n*F\n+ 1 ImageFormatChecker.kt\ncom/facebook/imageformat/ImageFormatChecker\n*L\n59#1:170,2\n*E\n"})
public final class ImageFormatChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int maxHeaderLength;
    @Nullable
    private List<? extends ImageFormat.FormatChecker> customImageFormatCheckers;
    @NotNull
    private final DefaultImageFormatChecker defaultFormatChecker = new DefaultImageFormatChecker();
    private boolean binaryXmlEnabled;
    @NotNull
    private static final Lazy<ImageFormatChecker> instance$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, ImageFormatChecker::instance_delegate$lambda$2);

    private ImageFormatChecker() {
        this.updateMaxHeaderLength();
    }

    @NotNull
    public final ImageFormatChecker setCustomImageFormatCheckers(@Nullable List<? extends ImageFormat.FormatChecker> customImageFormatCheckers) {
        this.customImageFormatCheckers = customImageFormatCheckers;
        this.updateMaxHeaderLength();
        return this;
    }

    @NotNull
    public final ImageFormatChecker setBinaryXmlEnabled(boolean binaryXmlEnabled) {
        this.binaryXmlEnabled = binaryXmlEnabled;
        return this;
    }

    @NotNull
    public final ImageFormat determineImageFormat(@NotNull InputStream is) throws IOException {
        block2: {
            Intrinsics.checkNotNullParameter((Object)is, (String)"is");
            byte[] imageHeaderBytes = new byte[this.maxHeaderLength];
            int headerSize = ImageFormatChecker.Companion.readHeaderFromStream(this.maxHeaderLength, is, imageHeaderBytes);
            ImageFormat $this$determineImageFormat_u24lambda_u240 = this.defaultFormatChecker.determineFormat(imageHeaderBytes, headerSize);
            boolean bl = false;
            ImageFormat format = Intrinsics.areEqual((Object)$this$determineImageFormat_u24lambda_u240, (Object)DefaultImageFormats.BINARY_XML) && !this.binaryXmlEnabled ? ImageFormat.UNKNOWN : $this$determineImageFormat_u24lambda_u240;
            if (format != ImageFormat.UNKNOWN) {
                return format;
            }
            List<? extends ImageFormat.FormatChecker> list = this.customImageFormatCheckers;
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ImageFormat.FormatChecker formatChecker = (ImageFormat.FormatChecker)element$iv;
                boolean bl2 = false;
                ImageFormat format2 = formatChecker.determineFormat(imageHeaderBytes, headerSize);
                if (format2 == ImageFormat.UNKNOWN) continue;
                return format2;
            }
        }
        return ImageFormat.UNKNOWN;
    }

    private final void updateMaxHeaderLength() {
        this.maxHeaderLength = this.defaultFormatChecker.getHeaderSize();
        if (this.customImageFormatCheckers != null) {
            List<? extends ImageFormat.FormatChecker> list = this.customImageFormatCheckers;
            Intrinsics.checkNotNull(list);
            for (ImageFormat.FormatChecker formatChecker : list) {
                this.maxHeaderLength = Math.max(this.maxHeaderLength, formatChecker.getHeaderSize());
            }
        }
    }

    private static final ImageFormatChecker instance_delegate$lambda$2() {
        return new ImageFormatChecker();
    }

    @JvmStatic
    @NotNull
    public static final ImageFormatChecker getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final ImageFormat getImageFormat(@NotNull InputStream is) throws IOException {
        return Companion.getImageFormat(is);
    }

    @JvmStatic
    @NotNull
    public static final ImageFormat getImageFormat_WrapIOException(@NotNull InputStream is) {
        return Companion.getImageFormat_WrapIOException(is);
    }

    @JvmStatic
    @NotNull
    public static final ImageFormat getImageFormat(@Nullable String filename) {
        return Companion.getImageFormat(filename);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007R\u001b\u0010\u000b\u001a\u00020\f8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/facebook/imageformat/ImageFormatChecker$Companion;", "", "<init>", "()V", "readHeaderFromStream", "", "maxHeaderLength", "is", "Ljava/io/InputStream;", "imageHeaderBytes", "", "instance", "Lcom/facebook/imageformat/ImageFormatChecker;", "getInstance", "()Lcom/facebook/imageformat/ImageFormatChecker;", "instance$delegate", "Lkotlin/Lazy;", "getImageFormat", "Lcom/facebook/imageformat/ImageFormat;", "getImageFormat_WrapIOException", "filename", "", "imagepipeline-base_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int readHeaderFromStream(int maxHeaderLength, InputStream is, byte[] imageHeaderBytes) throws IOException {
            int n;
            if (!(imageHeaderBytes.length >= maxHeaderLength)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (is.markSupported()) {
                int n2;
                try {
                    is.mark(maxHeaderLength);
                    n2 = ByteStreams.read((InputStream)is, (byte[])imageHeaderBytes, (int)0, (int)maxHeaderLength);
                }
                finally {
                    is.reset();
                }
                n = n2;
            } else {
                n = ByteStreams.read((InputStream)is, (byte[])imageHeaderBytes, (int)0, (int)maxHeaderLength);
            }
            return n;
        }

        @JvmStatic
        @NotNull
        public final ImageFormatChecker getInstance() {
            Lazy lazy = instance$delegate;
            return (ImageFormatChecker)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final ImageFormat getImageFormat(@NotNull InputStream is) throws IOException {
            Intrinsics.checkNotNullParameter((Object)is, (String)"is");
            return this.getInstance().determineImageFormat(is);
        }

        @JvmStatic
        @NotNull
        public final ImageFormat getImageFormat_WrapIOException(@NotNull InputStream is) {
            ImageFormat imageFormat;
            Intrinsics.checkNotNullParameter((Object)is, (String)"is");
            try {
                imageFormat = this.getImageFormat(is);
            }
            catch (IOException ioe) {
                throw Throwables.propagate((Throwable)ioe);
            }
            return imageFormat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final ImageFormat getImageFormat(@Nullable String filename) {
            ImageFormat imageFormat;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(filename);
                imageFormat = this.getImageFormat(fileInputStream);
            }
            catch (IOException ioe) {
                imageFormat = ImageFormat.UNKNOWN;
            }
            finally {
                Closeables.closeQuietly((InputStream)fileInputStream);
            }
            return imageFormat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

